"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeUnits = exports.extraTimeUnits = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeUnits = [{
  value: 'd',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.daysLabel', {
    defaultMessage: 'days'
  })
}, {
  value: 'h',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.hoursLabel', {
    defaultMessage: 'hours'
  })
}, {
  value: 'm',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.minutesLabel', {
    defaultMessage: 'minutes'
  })
}, {
  value: 's',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.secondsLabel', {
    defaultMessage: 'seconds'
  })
}];

// These are the time units that are not supported by the UI, but are supported by the ES API.
exports.timeUnits = timeUnits;
const extraTimeUnits = [{
  value: 'ms',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.msLabel', {
    defaultMessage: 'milliseconds'
  })
}, {
  value: 'micros',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.microsLabel', {
    defaultMessage: 'microseconds'
  })
}, {
  value: 'nanos',
  text: _i18n.i18n.translate('xpack.idxMgmt.dataStream.retention.timeUnits.nanosLabel', {
    defaultMessage: 'nanoseconds'
  })
}];
exports.extraTimeUnits = extraTimeUnits;