"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemas = exports.nameConfigWithoutValidations = exports.nameConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  containsCharsField,
  startsWithField,
  indexPatternField,
  lowerCaseStringField,
  isJsonField
} = _shared_imports.fieldValidators;
const {
  toInt
} = _shared_imports.fieldFormatters;
const indexPatternInvalidCharacters = _constants.INVALID_INDEX_PATTERN_CHARS.join(' ');
const nameConfig = {
  type: _shared_imports.FIELD_TYPES.TEXT,
  label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldNameLabel', {
    defaultMessage: 'Name'
  }),
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNameRequiredError', {
      defaultMessage: 'A template name is required.'
    }))
  }, {
    validator: containsCharsField({
      chars: ' ',
      message: _i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNameSpacesError', {
        defaultMessage: 'Spaces are not allowed in a template name.'
      })
    })
  }, {
    validator: startsWithField({
      char: '_',
      message: _i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNameUnderscoreError', {
        defaultMessage: 'A template name must not start with an underscore.'
      })
    })
  }, {
    validator: startsWithField({
      char: '.',
      message: _i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNamePeriodError', {
        defaultMessage: 'A template name must not start with a period.'
      })
    })
  }, {
    validator: containsCharsField({
      chars: _constants.INVALID_TEMPLATE_NAME_CHARS,
      message: ({
        charsFound
      }) => _i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNameInvalidaCharacterError', {
        defaultMessage: 'A template name must not contain the character "{invalidChar}"',
        values: {
          invalidChar: charsFound[0]
        }
      })
    })
  }, {
    validator: lowerCaseStringField(_i18n.i18n.translate('xpack.idxMgmt.templateValidation.templateNameLowerCaseRequiredError', {
      defaultMessage: 'The template name must be in lowercase.'
    }))
  }]
};
exports.nameConfig = nameConfig;
const nameConfigWithoutValidations = {
  ...nameConfig,
  validations: []
};
exports.nameConfigWithoutValidations = nameConfigWithoutValidations;
const schemas = {
  logistics: {
    name: nameConfig,
    indexPatterns: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      defaultValue: [],
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldIndexPatternsLabel', {
        defaultMessage: 'Index patterns'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateForm.stepLogistics.fieldIndexPatternsHelpText",
        defaultMessage: "Spaces and the characters {invalidCharactersList} are not allowed.",
        values: {
          invalidCharactersList: /*#__PURE__*/_react.default.createElement("strong", null, indexPatternInvalidCharacters)
        }
      }),
      validations: [{
        validator: emptyField(_i18n.i18n.translate('xpack.idxMgmt.templateValidation.indexPatternsRequiredError', {
          defaultMessage: 'At least one index pattern is required.'
        }))
      }, {
        validator: indexPatternField(_i18n.i18n),
        type: _shared_imports.VALIDATION_TYPES.ARRAY_ITEM,
        isBlocking: false
      }]
    },
    doCreateDataStream: {
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.datastreamLabel', {
        defaultMessage: 'Create data stream'
      }),
      defaultValue: false
    },
    order: {
      type: _shared_imports.FIELD_TYPES.NUMBER,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldOrderLabel', {
        defaultMessage: 'Order (optional)'
      }),
      formatters: [toInt]
    },
    priority: {
      type: _shared_imports.FIELD_TYPES.NUMBER,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldPriorityLabel', {
        defaultMessage: 'Priority (optional)'
      }),
      formatters: [toInt]
    },
    version: {
      type: _shared_imports.FIELD_TYPES.NUMBER,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldVersionLabel', {
        defaultMessage: 'Version (optional)'
      }),
      formatters: [toInt]
    },
    'lifecycle.enabled': {
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.enableDataRetentionLabel', {
        defaultMessage: 'Enable data retention'
      }),
      defaultValue: false
    },
    'lifecycle.infiniteDataRetention': {
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.infiniteDataRetentionLabel', {
        defaultMessage: 'Keep data indefinitely'
      }),
      defaultValue: false
    },
    'lifecycle.value': {
      type: _shared_imports.FIELD_TYPES.TEXT,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldDataRetentionValueLabel', {
        defaultMessage: 'Data Retention'
      }),
      formatters: [toInt],
      validations: [{
        validator: ({
          value,
          formData
        }) => {
          // If infiniteRetentionPeriod is set, we dont need to validate the data retention field
          if (formData['lifecycle.infiniteDataRetention']) {
            return undefined;
          }
          if (!value) {
            return {
              message: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataRetentionFieldRequiredError', {
                defaultMessage: 'A data retention value is required.'
              })
            };
          }
          if (value <= 0) {
            return {
              message: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataRetentionFieldNonNegativeError', {
                defaultMessage: `A positive value is required.`
              })
            };
          }
          if (value % 1 !== 0) {
            return {
              message: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataRetentionFieldDecimalError', {
                defaultMessage: `The value should be an integer number.`
              })
            };
          }
        }
      }]
    },
    'lifecycle.unit': {
      type: _shared_imports.FIELD_TYPES.TEXT,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldDataRetentionUnitLabel', {
        defaultMessage: 'Time unit'
      }),
      defaultValue: 'd'
    },
    allowAutoCreate: {
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.fieldAllowAutoCreateLabel', {
        defaultMessage: 'Allow auto create (optional)'
      }),
      defaultValue: false
    },
    _meta: {
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.metaFieldEditorLabel', {
        defaultMessage: '_meta field data (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateForm.stepLogistics.metaFieldEditorHelpText",
        defaultMessage: "Use JSON format: {code}",
        values: {
          code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, JSON.stringify({
            arbitrary_data: 'anything_goes'
          }))
        }
      }),
      validations: [{
        validator: isJsonField(_i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.metaFieldEditorJsonError', {
          defaultMessage: 'The _meta field JSON is not valid.'
        }), {
          allowEmptyString: true
        })
      }],
      deserializer: value => {
        if (value === '') {
          return value;
        }
        return JSON.stringify(value, null, 2);
      },
      serializer: value => {
        try {
          return JSON.parse(value);
        } catch (error) {
          // swallow error and return non-parsed value;
          return value;
        }
      }
    },
    addMeta: {
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.addMetadataLabel', {
        defaultMessage: 'Add metadata'
      })
    }
  }
};
exports.schemas = schemas;