"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnitField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnitField = ({
  path,
  disabled,
  options,
  euiFieldProps
}) => {
  const [open, setOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: path,
    path: path
  }, field => {
    var _options$find$text, _options$find;
    const onSelect = option => {
      field.setValue(option);
      setOpen(false);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        color: "text",
        iconSide: "right",
        iconType: "arrowDown",
        onClick: () => setOpen(isOpen => !isOpen),
        "data-test-subj": "show-filters-button",
        disabled: disabled
      }, (_options$find$text = (_options$find = options.find(timeUnitOption => timeUnitOption.value === field.value)) === null || _options$find === void 0 ? void 0 : _options$find.text) !== null && _options$find$text !== void 0 ? _options$find$text : `${field.value}`),
      ownFocus: true,
      panelPaddingSize: "none",
      isOpen: open,
      closePopover: () => setOpen(false)
    }, euiFieldProps), options.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: item.value,
      checked: field.value === item.value ? 'on' : undefined,
      onClick: () => onSelect(item.value),
      "data-test-subj": `filter-option-${item.value}`
    }, item.text)));
  });
};
exports.UnitField = UnitField;