"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldsListItemContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mappings_state_context = require("../../mappings_state_context");
var _runtimefields_list_item = require("./runtimefields_list_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuntimeFieldsListItemContainer = ({
  fieldId
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    runtimeFieldsList: {
      status,
      fieldToEdit
    },
    runtimeFields
  } = (0, _mappings_state_context.useMappingsState)();
  const getField = (0, _react.useCallback)(id => runtimeFields[id], [runtimeFields]);
  const field = getField(fieldId);
  const isHighlighted = fieldToEdit === fieldId;
  const isDimmed = status === 'editingField' && fieldToEdit !== fieldId;
  const areActionButtonsVisible = status === 'idle';
  const editField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'runtimeFieldsList.editField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_runtimefields_list_item.RuntimeFieldsListItem, {
    field: field,
    isHighlighted: isHighlighted,
    isDimmed: isDimmed,
    areActionButtonsVisible: areActionButtonsVisible,
    editField: editField
  });
};
exports.RuntimeFieldsListItemContainer = RuntimeFieldsListItemContainer;