"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRuntimeFieldProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mappings_state_context = require("../../mappings_state_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteRuntimeFieldProvider = ({
  children
}) => {
  const [state, setState] = (0, _react.useState)({
    isModalOpen: false
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const confirmButtonText = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.removeButtonLabel', {
    defaultMessage: 'Remove'
  });
  let modalTitle;
  if (state.field) {
    const {
      source
    } = state.field;
    modalTitle = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.title', {
      defaultMessage: "Remove runtime field '{fieldName}'?",
      values: {
        fieldName: source.name
      }
    });
  }
  const deleteField = field => {
    setState({
      isModalOpen: true,
      field
    });
  };
  const closeModal = () => {
    setState({
      isModalOpen: false
    });
  };
  const confirmDelete = () => {
    dispatch({
      type: 'runtimeField.remove',
      value: state.field.id
    });
    closeModal();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(deleteField), state.isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: modalTitle,
    "data-test-subj": "runtimeFieldDeleteConfirmModal",
    onCancel: closeModal,
    onConfirm: confirmDelete,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    buttonColor: "danger",
    confirmButtonText: confirmButtonText
  }));
};
exports.DeleteRuntimeFieldProvider = DeleteRuntimeFieldProvider;