"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsListItemContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mappings_state_context = require("../../../mappings_state_context");
var _fields_list_item = require("./fields_list_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldsListItemContainer = ({
  fieldId,
  treeDepth,
  isLastItem
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const listElement = (0, _react.useRef)(null);
  const {
    documentFields: {
      status,
      fieldToAddFieldTo,
      fieldToEdit
    },
    fields: {
      byId,
      maxNestedDepth,
      rootLevelFields
    },
    runtimeFields
  } = (0, _mappings_state_context.useMappingsState)();
  const getField = (0, _react.useCallback)(id => byId[id], [byId]);
  const runtimeFieldNames = Object.values(runtimeFields).map(field => field.source.name);
  const field = getField(fieldId);
  const {
    childFields
  } = field;
  const isHighlighted = fieldToEdit === fieldId;
  const isDimmed = status === 'editingField' && fieldToEdit !== fieldId;
  const isCreateFieldFormVisible = status === 'creatingField' && fieldToAddFieldTo === fieldId;
  const areActionButtonsVisible = status === 'idle';
  const childFieldsArray = (0, _react.useMemo)(() => childFields !== undefined ? childFields.map(getField) : [], [childFields, getField]);
  // Indicate if the field is shadowed by a runtime field with the same name
  // Currently this can only occur for **root level** fields.
  const isShadowed = rootLevelFields.includes(fieldId) && runtimeFieldNames.includes(field.source.name);
  const addField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.createField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  const editField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.editField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  const toggleExpand = (0, _react.useCallback)(() => {
    dispatch({
      type: 'field.toggleExpand',
      value: {
        fieldId
      }
    });
  }, [fieldId, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_fields_list_item.FieldsListItem, {
    ref: listElement,
    field: field,
    allFields: byId,
    treeDepth: treeDepth,
    isHighlighted: isHighlighted,
    isDimmed: isDimmed,
    isShadowed: isShadowed,
    isCreateFieldFormVisible: isCreateFieldFormVisible,
    areActionButtonsVisible: areActionButtonsVisible,
    isLastItem: isLastItem,
    childFieldsArray: childFieldsArray,
    maxNestedDepth: maxNestedDepth,
    addField: addField,
    editField: editField,
    toggleExpand: toggleExpand
  });
};
exports.FieldsListItemContainer = FieldsListItemContainer;