"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFieldHeaderForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../../constants");
var _field_parameters = require("../../field_parameters");
var _field_beta_badge = require("../field_beta_badge");
var _field_description_section = require("./field_description_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTypeDefinition = (type, subType) => {
  if (!type) {
    return;
  }
  const typeDefinition = _constants.TYPE_DEFINITION[type];
  const hasSubType = typeDefinition.subTypes !== undefined;
  if (hasSubType) {
    if (subType) {
      return _constants.TYPE_DEFINITION[subType];
    }
    return;
  }
  return typeDefinition;
};
const EditFieldHeaderForm = /*#__PURE__*/_react.default.memo(({
  defaultValue,
  isRootLevelField,
  isMultiField
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_parameters.NameParameter, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_parameters.TypeParameter, {
    isRootLevelField: isRootLevelField,
    isMultiField: isMultiField
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, ({
    type
  }) => {
    if (type === undefined) {
      return null;
    }
    const [fieldType] = type;
    return /*#__PURE__*/_react.default.createElement(_field_parameters.SubTypeParameter, {
      key: fieldType.value,
      type: fieldType.value,
      defaultValueType: defaultValue.type,
      isMultiField: isMultiField,
      isRootLevelField: isRootLevelField
    });
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType']
  }, ({
    type,
    subType
  }) => {
    var _ref, _typeDefinition$descr;
    const typeDefinition = getTypeDefinition(type[0].value, subType && subType[0].value);
    const description = (_ref = typeDefinition === null || typeDefinition === void 0 ? void 0 : (_typeDefinition$descr = typeDefinition.description) === null || _typeDefinition$descr === void 0 ? void 0 : _typeDefinition$descr.call(typeDefinition)) !== null && _ref !== void 0 ? _ref : null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), (typeDefinition === null || typeDefinition === void 0 ? void 0 : typeDefinition.isBeta) && /*#__PURE__*/_react.default.createElement(_field_beta_badge.FieldBetaBadge, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_field_description_section.FieldDescriptionSection, {
      isMultiField: isMultiField
    }, description));
  }));
});
exports.EditFieldHeaderForm = EditFieldHeaderForm;