"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequiredParametersFormForType = void 0;
var _alias_type = require("./alias_type");
var _token_count_type = require("./token_count_type");
var _scaled_float_type = require("./scaled_float_type");
var _dense_vector_type = require("./dense_vector_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typeToParametersFormMap = {
  alias: _alias_type.AliasTypeRequiredParameters,
  token_count: _token_count_type.TokenCountTypeRequiredParameters,
  scaled_float: _scaled_float_type.ScaledFloatTypeRequiredParameters,
  dense_vector: _dense_vector_type.DenseVectorRequiredParameters
};
const getRequiredParametersFormForType = (type, subType) => typeToParametersFormMap[subType] || typeToParametersFormMap[type];
exports.getRequiredParametersFormForType = getRequiredParametersFormForType;