"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzersParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _edit_field = require("../fields/edit_field");
var _analyzer_parameter = require("./analyzer_parameter");
var _documentation = require("../../../../../services/documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyzersParameter = ({
  field,
  withSearchQuoteAnalyzer = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.analyzersSectionTitle', {
      defaultMessage: 'Analyzers'
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.analyzersDocLinkText', {
        defaultMessage: 'Analyzers documentation'
      }),
      href: _documentation.documentationService.getAnalyzerLink()
    },
    withToggle: false,
    "data-test-subj": "analyzerParameters"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "useSameAnalyzerForSearch"
  }, ({
    useSameAnalyzerForSearch
  }) => {
    const label = useSameAnalyzerForSearch ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.indexSearchAnalyzerFieldLabel', {
      defaultMessage: 'Index and search analyzer'
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.indexAnalyzerFieldLabel', {
      defaultMessage: 'Index analyzer'
    });
    return /*#__PURE__*/_react.default.createElement(_analyzer_parameter.AnalyzerParameter, {
      path: "analyzer",
      label: label,
      defaultValue: field.source.analyzer,
      "data-test-subj": "indexAnalyzer"
    });
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "useSameAnalyzerForSearch",
    component: _shared_imports.CheckBoxField,
    componentProps: {
      'data-test-subj': 'useSameAnalyzerForSearchCheckBox'
    },
    config: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.analyzers.useSameAnalyzerIndexAnSearch', {
        defaultMessage: 'Use the same analyzers for index and searching'
      }),
      defaultValue: true
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "useSameAnalyzerForSearch"
  }, ({
    useSameAnalyzerForSearch
  }) => useSameAnalyzerForSearch ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_analyzer_parameter.AnalyzerParameter, {
    path: "search_analyzer",
    defaultValue: field.source.search_analyzer,
    config: (0, _lib.getFieldConfig)('search_analyzer'),
    "data-test-subj": "searchAnalyzer"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), withSearchQuoteAnalyzer && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_analyzer_parameter.AnalyzerParameter, {
    path: "search_quote_analyzer",
    defaultValue: field.source.search_quote_analyzer,
    config: (0, _lib.getFieldConfig)('search_quote_analyzer'),
    "data-test-subj": "searchQuoteAnalyzer"
  })));
};
exports.AnalyzersParameter = AnalyzersParameter;