"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutProps = exports.SimulateTemplateFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
var _simulate_template = require("./simulate_template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CheckBox = (0, _shared_imports.getUseField)({
  component: _shared_imports.CheckBoxField
});
const defaultFlyoutProps = {
  'data-test-subj': 'simulateTemplateFlyout',
  'aria-labelledby': 'simulateTemplateFlyoutTitle'
};
exports.defaultFlyoutProps = defaultFlyoutProps;
const i18nTexts = {
  filters: {
    label: _i18n.i18n.translate('xpack.idxMgmt.simulateTemplate.filters.label', {
      defaultMessage: 'Include:'
    }),
    mappings: _i18n.i18n.translate('xpack.idxMgmt.simulateTemplate.filters.mappings', {
      defaultMessage: 'Mappings'
    }),
    indexSettings: _i18n.i18n.translate('xpack.idxMgmt.simulateTemplate.filters.indexSettings', {
      defaultMessage: 'Index settings'
    }),
    aliases: _i18n.i18n.translate('xpack.idxMgmt.simulateTemplate.filters.aliases', {
      defaultMessage: 'Aliases'
    })
  }
};
const SimulateTemplateFlyoutContent = ({
  onClose,
  getTemplate,
  filters,
  onFiltersChange
}) => {
  const isMounted = (0, _react.useRef)(false);
  const [template, setTemplate] = (0, _react.useState)({});
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: filters
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    subscribe(formState => {
      onFiltersChange(formState.data.format());
    });
  }, [subscribe, onFiltersChange]);
  const updatePreview = (0, _react.useCallback)(async () => {
    const indexTemplate = await getTemplate();
    setTemplate(indexTemplate);
  }, [getTemplate]);
  (0, _react.useEffect)(() => {
    if (isMounted.current === false) {
      updatePreview();
    }
    isMounted.current = true;
  }, [updatePreview]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "componentTemplatesFlyoutTitle",
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.simulateTemplate.title",
    defaultMessage: "Preview index template"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.simulateTemplate.descriptionText",
    defaultMessage: "This is the final template that will be applied to matching indices based on the component templates you have selected and any overrides you've added."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18nTexts.filters.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CheckBox, {
    path: "mappings",
    config: {
      label: i18nTexts.filters.mappings
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CheckBox, {
    path: "settings",
    config: {
      label: i18nTexts.filters.indexSettings
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CheckBox, {
    path: "aliases",
    config: {
      label: i18nTexts.filters.aliases
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, null, formData => {
    return /*#__PURE__*/_react.default.createElement(_simulate_template.SimulateTemplate, {
      template: template,
      filters: formData
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClose,
    "data-test-subj": "closeDetailsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.simulateTemplate.closeButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: updatePreview,
    "data-test-subj": "updateSimulationButton",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.simulateTemplate.updateButtonLabel",
    defaultMessage: "Update"
  }))))));
};
exports.SimulateTemplateFlyoutContent = SimulateTemplateFlyoutContent;