"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLifecyclePolicyConfirmModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _api = require("../../application/services/api");
var _api_errors = require("../../application/services/api_errors");
var _notification = require("../../application/services/notification");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AddLifecyclePolicyConfirmModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "addPolicy", async () => {
      const {
        indexName,
        closeModal,
        reloadIndices
      } = this.props;
      const {
        selectedPolicyName,
        selectedAlias
      } = this.state;
      if (!selectedPolicyName) {
        this.setState({
          policyErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPolicySelectedErrorMessage', {
            defaultMessage: 'You must select a policy.'
          })
        });
        return;
      }
      try {
        const body = {
          indexName,
          policyName: selectedPolicyName,
          alias: selectedAlias
        };
        await (0, _api.addLifecyclePolicyToIndex)(body);
        closeModal();
        _notification.toasts.addSuccess(_i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexSuccess', {
          defaultMessage: 'Added policy {policyName} to index {indexName}.',
          values: {
            policyName: selectedPolicyName,
            indexName
          }
        }));
        reloadIndices();
      } catch (err) {
        (0, _api_errors.showApiError)(err, _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexError', {
          defaultMessage: 'Error adding policy to index'
        }));
      }
    });
    (0, _defineProperty2.default)(this, "renderAliasFormElement", selectedPolicy => {
      const {
        selectedAlias
      } = this.state;
      const {
        index
      } = this.props;
      const showAliasSelect = selectedPolicy && (0, _lodash.get)(selectedPolicy, 'policy.phases.hot.actions.rollover');
      if (!showAliasSelect) {
        return null;
      }
      const {
        aliases
      } = index;
      if (aliases === 'none') {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          style: {
            maxWidth: 400
          },
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningTitle",
            defaultMessage: "Index has no aliases"
          }),
          color: "warning"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningMessage",
          defaultMessage: "Policy {policyName} is configured for rollover, but index {indexName} does not have an alias, which is required for rollover.",
          values: {
            policyName: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.name,
            indexName: index.name
          }
        })));
      }
      const aliasOptions = aliases.map(alias => {
        return {
          text: alias,
          value: alias
        };
      });
      aliasOptions.unshift({
        text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasMessage', {
          defaultMessage: 'Choose an alias'
        }),
        value: ''
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasLabel",
          defaultMessage: "Index rollover alias"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: aliasOptions,
        value: selectedAlias,
        onChange: e => {
          this.setState({
            selectedAlias: e.target.value
          });
        }
      }));
    });
    this.state = {
      policies: [],
      selectedPolicyName: '',
      selectedAlias: ''
    };
  }
  renderForm() {
    const {
      policies,
      selectedPolicyName,
      policyErrorMessage
    } = this.state;
    const selectedPolicy = selectedPolicyName ? policies.find(policy => policy.name === selectedPolicyName) : undefined;
    const options = policies.map(({
      name
    }) => {
      return {
        value: name,
        text: name
      };
    });
    options.unshift({
      value: '',
      text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyMessage', {
        defaultMessage: 'Select a lifecycle policy'
      })
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: !!policyErrorMessage,
      error: policyErrorMessage,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyLabel",
        defaultMessage: "Lifecycle policy"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: options,
      value: selectedPolicyName,
      onChange: e => {
        this.setState({
          policyErrorMessage: undefined,
          selectedPolicyName: e.target.value
        });
      }
    })), this.renderAliasFormElement(selectedPolicy));
  }
  async componentDidMount() {
    try {
      const policies = await (0, _api.loadPolicies)();
      this.setState({
        policies
      });
    } catch (err) {
      (0, _api_errors.showApiError)(err, _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.loadPolicyError', {
        defaultMessage: 'Error loading policy list'
      }));
      this.props.closeModal();
    }
  }
  render() {
    const {
      policies
    } = this.state;
    const {
      indexName,
      closeModal,
      getUrlForApp
    } = this.props;
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.modalTitle",
      defaultMessage: "Add lifecycle policy to \"{indexName}\"",
      values: {
        indexName
      }
    });
    if (!policies.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
        onClose: closeModal
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        style: {
          maxWidth: 400
        },
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPoliciesWarningTitle",
          defaultMessage: "No index lifecycle policies defined"
        }),
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getUrlForApp('management', {
          path: `data/index_lifecycle_management/policies/edit`
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.defineLifecyclePolicyLinkText",
        defaultMessage: "Define lifecycle policy"
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: title,
      onCancel: closeModal,
      onConfirm: this.addPolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.cancelButtonText",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyButtonText",
        defaultMessage: "Add policy"
      })
    }, this.renderForm());
  }
}
exports.AddLifecyclePolicyConfirmModal = AddLifecyclePolicyConfirmModal;