"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSerializer = void 0;
var _immer = require("immer");
var _lodash = require("lodash");
var _constants = require("../../../../constants");
var _serialize_migrate_and_allocate_actions = require("./serialize_migrate_and_allocate_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSerializer = originalPolicy => data => {
  const {
    _meta,
    ...updatedPolicy
  } = data;
  updatedPolicy.phases = {
    hot: {
      actions: {}
    },
    ...updatedPolicy.phases
  };
  return (0, _immer.produce)(originalPolicy !== null && originalPolicy !== void 0 ? originalPolicy : _constants.defaultPolicy, draft => {
    var _meta$hot, _meta$hot2, _meta$frozen;
    // Copy over all updated fields
    (0, _lodash.merge)(draft, updatedPolicy);

    /**
     * Important shared values for serialization
     */
    const isUsingRollover = Boolean(((_meta$hot = _meta.hot) === null || _meta$hot === void 0 ? void 0 : _meta$hot.isUsingDefaultRollover) || ((_meta$hot2 = _meta.hot) === null || _meta$hot2 === void 0 ? void 0 : _meta$hot2.customRollover.enabled));

    // Next copy over all meta fields and delete any fields that have been removed
    // by fields exposed in the form. It is very important that we do not delete
    // data that the form does not control! E.g., unfollow action in hot phase.

    /**
     * HOT PHASE SERIALIZATION
     */
    if (draft.phases.hot) {
      var _draft$phases$hot$min, _draft$phases$hot;
      draft.phases.hot.min_age = (_draft$phases$hot$min = draft.phases.hot.min_age) !== null && _draft$phases$hot$min !== void 0 ? _draft$phases$hot$min : '0ms';
      if ((_draft$phases$hot = draft.phases.hot) !== null && _draft$phases$hot !== void 0 && _draft$phases$hot.actions) {
        var _actions2, _actions3;
        const hotPhaseActions = draft.phases.hot.actions;

        /**
         * HOT PHASE ROLLOVER
         */
        if (isUsingRollover) {
          var _meta$hot3, _actions, _meta$hot7, _meta$hot8, _meta$hot9, _updatedPolicy$phases, _updatedPolicy$phases2, _meta$hot11, _meta$hot11$downsampl;
          if ((_meta$hot3 = _meta.hot) !== null && _meta$hot3 !== void 0 && _meta$hot3.isUsingDefaultRollover) {
            hotPhaseActions.rollover = (0, _lodash.cloneDeep)(_constants.defaultRolloverAction);
          } else {
            var _actions$rollover, _actions$rollover2, _actions$rollover3, _actions$rollover4, _actions$rollover5;
            // Rollover may not exist if editing an existing policy with initially no rollover configured
            if (!hotPhaseActions.rollover) {
              hotPhaseActions.rollover = {};
            }

            // We are using user-defined, custom rollover settings.
            if ((_actions$rollover = updatedPolicy.phases.hot.actions.rollover) !== null && _actions$rollover !== void 0 && _actions$rollover.max_age) {
              var _meta$hot4;
              hotPhaseActions.rollover.max_age = `${hotPhaseActions.rollover.max_age}${(_meta$hot4 = _meta.hot) === null || _meta$hot4 === void 0 ? void 0 : _meta$hot4.customRollover.maxAgeUnit}`;
            } else {
              delete hotPhaseActions.rollover.max_age;
            }
            if (typeof ((_actions$rollover2 = updatedPolicy.phases.hot.actions.rollover) === null || _actions$rollover2 === void 0 ? void 0 : _actions$rollover2.max_docs) !== 'number') {
              delete hotPhaseActions.rollover.max_docs;
            }
            if ((_actions$rollover3 = updatedPolicy.phases.hot.actions.rollover) !== null && _actions$rollover3 !== void 0 && _actions$rollover3.max_primary_shard_size) {
              var _meta$hot5;
              hotPhaseActions.rollover.max_primary_shard_size = `${hotPhaseActions.rollover.max_primary_shard_size}${(_meta$hot5 = _meta.hot) === null || _meta$hot5 === void 0 ? void 0 : _meta$hot5.customRollover.maxPrimaryShardSizeUnit}`;
            } else {
              delete hotPhaseActions.rollover.max_primary_shard_size;
            }
            if (typeof ((_actions$rollover4 = updatedPolicy.phases.hot.actions.rollover) === null || _actions$rollover4 === void 0 ? void 0 : _actions$rollover4.max_primary_shard_docs) !== 'number') {
              delete hotPhaseActions.rollover.max_primary_shard_docs;
            }
            if ((_actions$rollover5 = updatedPolicy.phases.hot.actions.rollover) !== null && _actions$rollover5 !== void 0 && _actions$rollover5.max_size) {
              var _meta$hot6;
              hotPhaseActions.rollover.max_size = `${hotPhaseActions.rollover.max_size}${(_meta$hot6 = _meta.hot) === null || _meta$hot6 === void 0 ? void 0 : _meta$hot6.customRollover.maxStorageSizeUnit}`;
            } else {
              delete hotPhaseActions.rollover.max_size;
            }
          }

          /**
           * HOT PHASE FORCEMERGE
           */
          if (!((_actions = updatedPolicy.phases.hot.actions) !== null && _actions !== void 0 && _actions.forcemerge)) {
            delete hotPhaseActions.forcemerge;
          } else if ((_meta$hot7 = _meta.hot) !== null && _meta$hot7 !== void 0 && _meta$hot7.bestCompression) {
            hotPhaseActions.forcemerge.index_codec = 'best_compression';
          } else {
            delete hotPhaseActions.forcemerge.index_codec;
          }
          if ((_meta$hot8 = _meta.hot) !== null && _meta$hot8 !== void 0 && _meta$hot8.bestCompression && hotPhaseActions.forcemerge) {
            hotPhaseActions.forcemerge.index_codec = 'best_compression';
          }

          /**
           * HOT PHASE READ-ONLY
           */
          if ((_meta$hot9 = _meta.hot) !== null && _meta$hot9 !== void 0 && _meta$hot9.readonlyEnabled) {
            var _hotPhaseActions$read;
            hotPhaseActions.readonly = (_hotPhaseActions$read = hotPhaseActions.readonly) !== null && _hotPhaseActions$read !== void 0 ? _hotPhaseActions$read : {};
          } else {
            delete hotPhaseActions.readonly;
          }
          /**
           * HOT PHASE SHRINK
           */
          if (!((_updatedPolicy$phases = updatedPolicy.phases.hot) !== null && _updatedPolicy$phases !== void 0 && (_updatedPolicy$phases2 = _updatedPolicy$phases.actions) !== null && _updatedPolicy$phases2 !== void 0 && _updatedPolicy$phases2.shrink)) {
            delete hotPhaseActions.shrink;
          } else if (_meta.hot.shrink.isUsingShardSize) {
            var _hotPhaseActions$shri, _meta$hot10;
            delete hotPhaseActions.shrink.number_of_shards;
            hotPhaseActions.shrink.max_primary_shard_size = `${(_hotPhaseActions$shri = hotPhaseActions.shrink) === null || _hotPhaseActions$shri === void 0 ? void 0 : _hotPhaseActions$shri.max_primary_shard_size}${(_meta$hot10 = _meta.hot) === null || _meta$hot10 === void 0 ? void 0 : _meta$hot10.shrink.maxPrimaryShardSizeUnits}`;
          } else {
            delete hotPhaseActions.shrink.max_primary_shard_size;
          }

          /**
           * HOT PHASE DOWNSAMPLE
           */
          if ((_meta$hot11 = _meta.hot) !== null && _meta$hot11 !== void 0 && (_meta$hot11$downsampl = _meta$hot11.downsample) !== null && _meta$hot11$downsampl !== void 0 && _meta$hot11$downsampl.enabled) {
            hotPhaseActions.downsample = {
              ...hotPhaseActions.downsample,
              fixed_interval: `${_meta.hot.downsample.fixedIntervalSize}${_meta.hot.downsample.fixedIntervalUnits}`
            };
          } else {
            delete hotPhaseActions.downsample;
          }
        } else {
          delete hotPhaseActions.rollover;
          delete hotPhaseActions.forcemerge;
          delete hotPhaseActions.readonly;
          delete hotPhaseActions.shrink;
        }
        /**
         * HOT PHASE SET PRIORITY
         */
        if (!((_actions2 = updatedPolicy.phases.hot.actions) !== null && _actions2 !== void 0 && _actions2.set_priority)) {
          delete hotPhaseActions.set_priority;
        }

        /**
         * HOT PHASE SEARCHABLE SNAPSHOT
         */
        if ((_actions3 = updatedPolicy.phases.hot.actions) !== null && _actions3 !== void 0 && _actions3.searchable_snapshot) {
          hotPhaseActions.searchable_snapshot = {
            ...hotPhaseActions.searchable_snapshot,
            snapshot_repository: _meta.searchableSnapshot.repository
          };
        } else {
          delete hotPhaseActions.searchable_snapshot;
        }
      }
    }

    /**
     * WARM PHASE SERIALIZATION
     */
    if (_meta.warm.enabled) {
      var _draft$phases$warm$ac, _draft$phases$warm, _updatedPolicy$phases3, _originalPolicy$phase, _updatedPolicy$phases4, _updatedPolicy$phases5, _updatedPolicy$phases6, _updatedPolicy$phases7, _updatedPolicy$phases8, _updatedPolicy$phases9, _updatedPolicy$phases10, _updatedPolicy$phases11, _updatedPolicy$phases12, _meta$warm2, _meta$warm2$downsampl;
      draft.phases.warm.actions = (_draft$phases$warm$ac = (_draft$phases$warm = draft.phases.warm) === null || _draft$phases$warm === void 0 ? void 0 : _draft$phases$warm.actions) !== null && _draft$phases$warm$ac !== void 0 ? _draft$phases$warm$ac : {};
      const warmPhase = draft.phases.warm;

      /**
       * WARM PHASE MIN AGE
       *
       */
      if ((_updatedPolicy$phases3 = updatedPolicy.phases.warm) !== null && _updatedPolicy$phases3 !== void 0 && _updatedPolicy$phases3.min_age) {
        warmPhase.min_age = `${updatedPolicy.phases.warm.min_age}${_meta.warm.minAgeUnit}`;
      }

      /**
       * WARM PHASE DATA ALLOCATION
       */
      warmPhase.actions = (0, _serialize_migrate_and_allocate_actions.serializeMigrateAndAllocateActions)(_meta.warm, warmPhase.actions, originalPolicy === null || originalPolicy === void 0 ? void 0 : (_originalPolicy$phase = originalPolicy.phases.warm) === null || _originalPolicy$phase === void 0 ? void 0 : _originalPolicy$phase.actions, (_updatedPolicy$phases4 = updatedPolicy.phases.warm) === null || _updatedPolicy$phases4 === void 0 ? void 0 : (_updatedPolicy$phases5 = _updatedPolicy$phases4.actions) === null || _updatedPolicy$phases5 === void 0 ? void 0 : (_updatedPolicy$phases6 = _updatedPolicy$phases5.allocate) === null || _updatedPolicy$phases6 === void 0 ? void 0 : _updatedPolicy$phases6.number_of_replicas);

      /**
       * WARM PHASE FORCEMERGE
       */
      if (!((_updatedPolicy$phases7 = updatedPolicy.phases.warm) !== null && _updatedPolicy$phases7 !== void 0 && (_updatedPolicy$phases8 = _updatedPolicy$phases7.actions) !== null && _updatedPolicy$phases8 !== void 0 && _updatedPolicy$phases8.forcemerge)) {
        delete warmPhase.actions.forcemerge;
      } else if (_meta.warm.bestCompression) {
        warmPhase.actions.forcemerge.index_codec = 'best_compression';
      } else {
        delete warmPhase.actions.forcemerge.index_codec;
      }

      /**
       * WARM PHASE READ ONLY
       */
      if (_meta.warm.readonlyEnabled) {
        var _warmPhase$actions$re;
        warmPhase.actions.readonly = (_warmPhase$actions$re = warmPhase.actions.readonly) !== null && _warmPhase$actions$re !== void 0 ? _warmPhase$actions$re : {};
      } else {
        delete warmPhase.actions.readonly;
      }

      /**
       * WARM PHASE SET PRIORITY
       */
      if (!((_updatedPolicy$phases9 = updatedPolicy.phases.warm) !== null && _updatedPolicy$phases9 !== void 0 && (_updatedPolicy$phases10 = _updatedPolicy$phases9.actions) !== null && _updatedPolicy$phases10 !== void 0 && _updatedPolicy$phases10.set_priority)) {
        delete warmPhase.actions.set_priority;
      }

      /**
       * WARM PHASE SHRINK
       */
      if (!((_updatedPolicy$phases11 = updatedPolicy.phases.warm) !== null && _updatedPolicy$phases11 !== void 0 && (_updatedPolicy$phases12 = _updatedPolicy$phases11.actions) !== null && _updatedPolicy$phases12 !== void 0 && _updatedPolicy$phases12.shrink)) {
        delete warmPhase.actions.shrink;
      } else if (_meta.warm.shrink.isUsingShardSize) {
        var _warmPhase$actions$sh, _meta$warm;
        delete warmPhase.actions.shrink.number_of_shards;
        warmPhase.actions.shrink.max_primary_shard_size = `${(_warmPhase$actions$sh = warmPhase.actions.shrink) === null || _warmPhase$actions$sh === void 0 ? void 0 : _warmPhase$actions$sh.max_primary_shard_size}${(_meta$warm = _meta.warm) === null || _meta$warm === void 0 ? void 0 : _meta$warm.shrink.maxPrimaryShardSizeUnits}`;
      } else {
        delete warmPhase.actions.shrink.max_primary_shard_size;
      }

      /**
       * WARM PHASE DOWNSAMPLE
       */
      if ((_meta$warm2 = _meta.warm) !== null && _meta$warm2 !== void 0 && (_meta$warm2$downsampl = _meta$warm2.downsample) !== null && _meta$warm2$downsampl !== void 0 && _meta$warm2$downsampl.enabled) {
        warmPhase.actions.downsample = {
          ...warmPhase.actions.downsample,
          fixed_interval: `${_meta.warm.downsample.fixedIntervalSize}${_meta.warm.downsample.fixedIntervalUnits}`
        };
      } else {
        delete warmPhase.actions.downsample;
      }
    } else {
      delete draft.phases.warm;
    }

    /**
     * COLD PHASE SERIALIZATION
     */
    if (_meta.cold.enabled) {
      var _draft$phases$cold$ac, _draft$phases$cold, _updatedPolicy$phases13, _originalPolicy$phase2, _updatedPolicy$phases14, _updatedPolicy$phases15, _updatedPolicy$phases16, _updatedPolicy$phases17, _updatedPolicy$phases18, _updatedPolicy$phases19, _updatedPolicy$phases20, _meta$cold, _meta$cold$downsample;
      draft.phases.cold.actions = (_draft$phases$cold$ac = (_draft$phases$cold = draft.phases.cold) === null || _draft$phases$cold === void 0 ? void 0 : _draft$phases$cold.actions) !== null && _draft$phases$cold$ac !== void 0 ? _draft$phases$cold$ac : {};
      const coldPhase = draft.phases.cold;

      /**
       * COLD PHASE MIN AGE
       */
      if ((_updatedPolicy$phases13 = updatedPolicy.phases.cold) !== null && _updatedPolicy$phases13 !== void 0 && _updatedPolicy$phases13.min_age) {
        coldPhase.min_age = `${updatedPolicy.phases.cold.min_age}${_meta.cold.minAgeUnit}`;
      }

      /**
       * COLD PHASE DATA ALLOCATION
       */
      coldPhase.actions = (0, _serialize_migrate_and_allocate_actions.serializeMigrateAndAllocateActions)(_meta.cold, coldPhase.actions, originalPolicy === null || originalPolicy === void 0 ? void 0 : (_originalPolicy$phase2 = originalPolicy.phases.cold) === null || _originalPolicy$phase2 === void 0 ? void 0 : _originalPolicy$phase2.actions, (_updatedPolicy$phases14 = updatedPolicy.phases.cold) === null || _updatedPolicy$phases14 === void 0 ? void 0 : (_updatedPolicy$phases15 = _updatedPolicy$phases14.actions) === null || _updatedPolicy$phases15 === void 0 ? void 0 : (_updatedPolicy$phases16 = _updatedPolicy$phases15.allocate) === null || _updatedPolicy$phases16 === void 0 ? void 0 : _updatedPolicy$phases16.number_of_replicas);

      /**
       * COLD PHASE FREEZE
       * The freeze action has been removed in 8.0.
       * Clean up any policies that still have this action configured
       */
      if (coldPhase.actions.freeze) {
        delete coldPhase.actions.freeze;
      }

      /**
       * COLD PHASE READ ONLY
       */
      if (_meta.cold.readonlyEnabled) {
        var _coldPhase$actions$re;
        coldPhase.actions.readonly = (_coldPhase$actions$re = coldPhase.actions.readonly) !== null && _coldPhase$actions$re !== void 0 ? _coldPhase$actions$re : {};
      } else {
        delete coldPhase.actions.readonly;
      }

      /**
       * COLD PHASE SET PRIORITY
       */
      if (!((_updatedPolicy$phases17 = updatedPolicy.phases.cold) !== null && _updatedPolicy$phases17 !== void 0 && (_updatedPolicy$phases18 = _updatedPolicy$phases17.actions) !== null && _updatedPolicy$phases18 !== void 0 && _updatedPolicy$phases18.set_priority)) {
        delete coldPhase.actions.set_priority;
      }

      /**
       * COLD PHASE SEARCHABLE SNAPSHOT
       */
      if ((_updatedPolicy$phases19 = updatedPolicy.phases.cold) !== null && _updatedPolicy$phases19 !== void 0 && (_updatedPolicy$phases20 = _updatedPolicy$phases19.actions) !== null && _updatedPolicy$phases20 !== void 0 && _updatedPolicy$phases20.searchable_snapshot) {
        coldPhase.actions.searchable_snapshot = {
          ...coldPhase.actions.searchable_snapshot,
          snapshot_repository: _meta.searchableSnapshot.repository
        };
      } else {
        delete coldPhase.actions.searchable_snapshot;
      }

      /**
       * COLD PHASE DOWNSAMPLE
       */
      if ((_meta$cold = _meta.cold) !== null && _meta$cold !== void 0 && (_meta$cold$downsample = _meta$cold.downsample) !== null && _meta$cold$downsample !== void 0 && _meta$cold$downsample.enabled) {
        coldPhase.actions.downsample = {
          ...coldPhase.actions.downsample,
          fixed_interval: `${_meta.cold.downsample.fixedIntervalSize}${_meta.cold.downsample.fixedIntervalUnits}`
        };
      } else {
        delete coldPhase.actions.downsample;
      }
    } else {
      delete draft.phases.cold;
    }

    /**
     * FROZEN PHASE SERIALIZATION
     */
    if ((_meta$frozen = _meta.frozen) !== null && _meta$frozen !== void 0 && _meta$frozen.enabled) {
      var _draft$phases$frozen$, _draft$phases$frozen, _updatedPolicy$phases21, _updatedPolicy$phases22, _updatedPolicy$phases23;
      draft.phases.frozen.actions = (_draft$phases$frozen$ = (_draft$phases$frozen = draft.phases.frozen) === null || _draft$phases$frozen === void 0 ? void 0 : _draft$phases$frozen.actions) !== null && _draft$phases$frozen$ !== void 0 ? _draft$phases$frozen$ : {};
      const frozenPhase = draft.phases.frozen;

      /**
       * FROZEN PHASE MIN AGE
       */
      if ((_updatedPolicy$phases21 = updatedPolicy.phases.frozen) !== null && _updatedPolicy$phases21 !== void 0 && _updatedPolicy$phases21.min_age) {
        frozenPhase.min_age = `${updatedPolicy.phases.frozen.min_age}${_meta.frozen.minAgeUnit}`;
      }

      /**
       * FROZEN PHASE SEARCHABLE SNAPSHOT
       */
      if ((_updatedPolicy$phases22 = updatedPolicy.phases.frozen) !== null && _updatedPolicy$phases22 !== void 0 && (_updatedPolicy$phases23 = _updatedPolicy$phases22.actions) !== null && _updatedPolicy$phases23 !== void 0 && _updatedPolicy$phases23.searchable_snapshot) {
        frozenPhase.actions.searchable_snapshot = {
          ...frozenPhase.actions.searchable_snapshot,
          snapshot_repository: _meta.searchableSnapshot.repository
        };
      } else {
        delete frozenPhase.actions.searchable_snapshot;
      }
    } else {
      delete draft.phases.frozen;
    }

    /**
     * DELETE PHASE SERIALIZATION
     */
    if (_meta.delete.enabled) {
      var _deletePhase$actions, _deletePhase$actions$, _updatedPolicy$phases24, _updatedPolicy$phases25, _updatedPolicy$phases26;
      const deletePhase = draft.phases.delete;

      /**
       * DELETE PHASE DELETE
       */
      deletePhase.actions = (_deletePhase$actions = deletePhase.actions) !== null && _deletePhase$actions !== void 0 ? _deletePhase$actions : {};
      deletePhase.actions.delete = (_deletePhase$actions$ = deletePhase.actions.delete) !== null && _deletePhase$actions$ !== void 0 ? _deletePhase$actions$ : {};

      /**
       * DELETE PHASE MIN AGE
       */
      if ((_updatedPolicy$phases24 = updatedPolicy.phases.delete) !== null && _updatedPolicy$phases24 !== void 0 && _updatedPolicy$phases24.min_age) {
        deletePhase.min_age = `${updatedPolicy.phases.delete.min_age}${_meta.delete.minAgeUnit}`;
      }

      /**
       * DELETE PHASE WAIT FOR SNAPSHOT
       */
      if (!((_updatedPolicy$phases25 = updatedPolicy.phases.delete) !== null && _updatedPolicy$phases25 !== void 0 && (_updatedPolicy$phases26 = _updatedPolicy$phases25.actions) !== null && _updatedPolicy$phases26 !== void 0 && _updatedPolicy$phases26.wait_for_snapshot)) {
        delete deletePhase.actions.wait_for_snapshot;
      }
    } else {
      delete draft.phases.delete;
    }
  });
};
exports.createSerializer = createSerializer;