"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WillUseFallbackTierNotice = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _node_role_to_fallback_tier_map = require("./node_role_to_fallback_tier_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  warm: {
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.warmPhase.dataTier.willUseFallbackTierTitle', {
      defaultMessage: 'No nodes assigned to the warm tier'
    }),
    body: nodeRole => _i18n.i18n.translate('xpack.indexLifecycleMgmt.warmPhase.dataTier.willUseFallbackTierDescription', {
      defaultMessage: 'If no warm nodes are available, data is stored in the {tier} tier.',
      values: {
        tier: _node_role_to_fallback_tier_map.nodeRoleToFallbackTierMap[nodeRole]
      }
    })
  },
  cold: {
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.coldPhase.dataTier.willUseFallbackTierTitle', {
      defaultMessage: 'No nodes assigned to the cold tier'
    }),
    body: nodeRole => _i18n.i18n.translate('xpack.indexLifecycleMgmt.coldPhase.dataTier.willUseFallbackTierDescription', {
      defaultMessage: 'If no cold nodes are available, data is stored in the {tier} tier.',
      values: {
        tier: _node_role_to_fallback_tier_map.nodeRoleToFallbackTierMap[nodeRole]
      }
    })
  }
};
const WillUseFallbackTierNotice = ({
  phase,
  targetNodeRole
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "willUseFallbackTierNotice",
    title: i18nTexts[phase].title
  }, i18nTexts[phase].body(targetNodeRole));
};
exports.WillUseFallbackTierNotice = WillUseFallbackTierNotice;