"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Phase = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _phase_icon = require("../../phase_icon");
var _phase_footer = require("../../phase_footer");
require("./phase.scss");
var _phase_title = require("./phase_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Phase = ({
  children,
  topLevelSettings,
  phase
}) => {
  const enabledPath = `_meta.${phase}.enabled`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [enabledPath]
  });
  const isHotPhase = phase === 'hot';
  const isDeletePhase = phase === 'delete';
  // hot phase is always enabled
  const enabled = (0, _lodash.get)(formData, enabledPath) || isHotPhase;

  // delete phase is hidden when disabled
  if (isDeletePhase && !enabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTimelineItem, {
    icon: /*#__PURE__*/_react.default.createElement(_phase_icon.PhaseIcon, {
      enabled: enabled,
      phase: phase
    }),
    verticalAlign: "top",
    "data-test-subj": `${phase}-phase`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    color: "transparent",
    hasBorder: true,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: enabled ? 'transparent' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_phase_title.PhaseTitle, {
    phase: phase
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    style: {
      maxWidth: '50%'
    }
  }, _i18n_texts.i18nTexts.editPolicy.descriptions[phase]), enabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!topLevelSettings ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), topLevelSettings) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `${phase}-settingsSwitch`,
    className: "ilmSettingsAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.phaseSettings.buttonLabel",
      defaultMessage: "Advanced settings"
    }),
    buttonClassName: "ilmSettingsButton",
    extraAction: !isDeletePhase && /*#__PURE__*/_react.default.createElement(_phase_footer.PhaseFooter, {
      phase: phase
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), children) : !isDeletePhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_phase_footer.PhaseFooter, {
    phase: phase
  })))))));
};
exports.Phase = Phase;