"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StringParameter = StringParameter;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function StringParameter({
  id,
  label,
  value,
  setParameter
}) {
  const handleChange = evt => {
    setParameter(id, evt.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: value,
    onChange: handleChange,
    fullWidth: true
  }));
}
StringParameter.propTypes = {
  id: _propTypes.default.string.isRequired,
  label: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  setParameter: _propTypes.default.func.isRequired
};