"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionPanel = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_navigation_handler = require("../app_navigation_handler");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SolutionPanel = ({
  addBasePath,
  solution
}) => {
  const {
    trackUiMetric
  } = (0, _kibana_services.getServices)();
  const getSolutionGraphicURL = solutionId => `/plugins/kibanaReact/assets/solutions_${solutionId}.svg`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "homSolutions__item",
    "data-test-subj": `homSolutionPanel homSolutionPanel_${solution.id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: `homSolutionPanel homSolutionPanel--${solution.id}`,
    description: solution.description,
    href: addBasePath(solution.path),
    icon: /*#__PURE__*/_react.default.createElement(_public.KibanaPageTemplateSolutionNavAvatar, {
      name: solution.title,
      iconType: solution.icon,
      size: "xl"
    }),
    image: addBasePath(getSolutionGraphicURL((0, _lodash.snakeCase)(solution.id))),
    onClick: event => {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, `solution_panel_${solution.id}`);
      (0, _app_navigation_handler.createAppNavigationHandler)(solution.path)(event);
    },
    title: solution.title,
    titleElement: "h2"
  }));
};
exports.SolutionPanel = SolutionPanel;