"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KEY_ENABLE_WELCOME = exports.Home = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
var _kibana_services = require("../kibana_services");
var _add_data = require("./add_data");
var _manage_data = require("./manage_data");
var _solutions_section = require("./solutions_section");
var _welcome = require("./welcome");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KEY_ENABLE_WELCOME = 'home:welcome:show';
exports.KEY_ENABLE_WELCOME = KEY_ENABLE_WELCOME;
class Home extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    const isWelcomeEnabled = !(0, _kibana_services.getServices)().homeConfig.disableWelcomeScreen && (0, _kibana_services.getServices)().application.capabilities.navLinks.integrations && props.localStorage.getItem(KEY_ENABLE_WELCOME) !== 'false';
    const body = document.querySelector('body');
    body.classList.add('isHomPage');
    this.state = {
      // If welcome is enabled, we wait for loading to complete
      // before rendering. This prevents an annoying flickering
      // effect where home renders, and then a few ms after, the
      // welcome screen fades in.
      isLoading: isWelcomeEnabled,
      isNewKibanaInstance: false,
      isWelcomeEnabled
    };
  }
  componentWillUnmount() {
    this._isMounted = false;
    const body = document.querySelector('body');
    body.classList.remove('isHomPage');
  }
  componentDidMount() {
    this._isMounted = true;
    this.fetchIsNewKibanaInstance();
    const homeTitle = _i18n.i18n.translate('home.breadcrumbs.homeTitle', {
      defaultMessage: 'Home'
    });
    (0, _kibana_services.getServices)().chrome.setBreadcrumbs([{
      text: homeTitle
    }]);
  }
  async fetchIsNewKibanaInstance() {
    try {
      // Set a max-time on this query so we don't hang the page too long...
      // Worst case, we don't show the welcome screen when we should.
      setTimeout(() => {
        if (this.state.isLoading) {
          this.setState({
            isWelcomeEnabled: false
          });
        }
      }, 10000);
      const hasUserIndexPattern = await this.props.hasUserDataView();
      this.endLoading({
        isNewKibanaInstance: !hasUserIndexPattern
      });
    } catch (err) {
      // An error here is relatively unimportant, as it only means we don't provide
      // some UI niceties.
      this.endLoading();
    }
  }
  endLoading(state = {}) {
    if (this._isMounted) {
      this.setState({
        ...state,
        isLoading: false
      });
    }
  }
  skipWelcome() {
    this.props.localStorage.setItem(KEY_ENABLE_WELCOME, 'false');
    if (this._isMounted) this.setState({
      isWelcomeEnabled: false
    });
  }
  findDirectoryById(id) {
    return this.props.directories.find(directory => directory.id === id);
  }
  getFeaturesByCategory(category) {
    return this.props.directories.filter(directory => directory.showOnHomePage && directory.category === category).sort((directoryA, directoryB) => {
      var _directoryA$order, _directoryB$order;
      return ((_directoryA$order = directoryA.order) !== null && _directoryA$order !== void 0 ? _directoryA$order : -1) - ((_directoryB$order = directoryB.order) !== null && _directoryB$order !== void 0 ? _directoryB$order : -1);
    });
  }
  renderNormal() {
    var _getServices$uiSettin;
    const {
      addBasePath,
      solutions,
      isCloudEnabled
    } = this.props;
    const {
      application,
      trackUiMetric
    } = (0, _kibana_services.getServices)();
    const isDarkMode = ((_getServices$uiSettin = (0, _kibana_services.getServices)().uiSettings) === null || _getServices$uiSettin === void 0 ? void 0 : _getServices$uiSettin.get('theme:darkMode')) || false;
    const devTools = this.findDirectoryById('console');
    const manageDataFeatures = this.getFeaturesByCategory('admin');

    // Show card for console if none of the manage data plugins are available, most likely in OSS
    if (manageDataFeatures.length < 1 && devTools) {
      manageDataFeatures.push(devTools);
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      "data-test-subj": "homeApp",
      pageHeader: {
        bottomBorder: false,
        pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "home.header.title",
          defaultMessage: "Welcome home"
        })
      },
      panelled: false
    }, /*#__PURE__*/_react.default.createElement(_solutions_section.SolutionsSection, {
      addBasePath: addBasePath,
      solutions: solutions
    }), /*#__PURE__*/_react.default.createElement(_add_data.AddData, {
      addBasePath: addBasePath,
      application: application,
      isDarkMode: isDarkMode,
      isCloudEnabled: isCloudEnabled
    }), /*#__PURE__*/_react.default.createElement(_manage_data.ManageData, {
      addBasePath: addBasePath,
      application: application,
      features: manageDataFeatures
    }), /*#__PURE__*/_react.default.createElement(_public.OverviewPageFooter, {
      addBasePath: addBasePath,
      path: _constants.HOME_APP_BASE_PATH,
      onSetDefaultRoute: () => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'set_home_as_default_route');
      },
      onChangeDefaultRoute: () => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'change_to_different_default_route');
      }
    }));
  }

  // For now, loading is just an empty page, as we'll show something
  // in 250ms, no matter what, and a blank page prevents an odd flicker effect.
  renderLoading() {
    return '';
  }
  renderWelcome() {
    return /*#__PURE__*/_react.default.createElement(_welcome.Welcome, {
      onSkip: () => this.skipWelcome(),
      urlBasePath: this.props.urlBasePath
    });
  }
  render() {
    const {
      isLoading,
      isWelcomeEnabled,
      isNewKibanaInstance
    } = this.state;
    const {
      application,
      guidedOnboardingService
    } = (0, _kibana_services.getServices)();
    if (isWelcomeEnabled) {
      if (isLoading) {
        return this.renderLoading();
      }
      if (isNewKibanaInstance) {
        if (guidedOnboardingService !== null && guidedOnboardingService !== void 0 && guidedOnboardingService.isEnabled) {
          application.navigateToUrl('./home#/getting_started');
          return null;
        }
        return this.renderWelcome();
      }
    }
    return this.renderNormal();
  }
}
exports.Home = Home;