"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUIDED_ONBOARDING_FEATURE = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _constants = require("../common/constants");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GUIDED_ONBOARDING_FEATURE = {
  id: _constants.PLUGIN_FEATURE,
  name: _i18n.i18n.translate('guidedOnboarding.featureRegistry.featureName', {
    defaultMessage: 'Setup guides'
  }),
  category: _server.DEFAULT_APP_CATEGORIES.management,
  app: [_constants.PLUGIN_ID],
  privileges: {
    all: {
      app: [_constants.PLUGIN_ID],
      savedObject: {
        all: [_saved_objects.guideStateSavedObjectsType, _saved_objects.pluginStateSavedObjectsType],
        read: []
      },
      ui: ['enabled']
    },
    read: {
      // we haven't implemented "read-only" access yet, so this feature can only be granted
      // as "all" or "none"
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      ui: []
    }
  }
};
exports.GUIDED_ONBOARDING_FEATURE = GUIDED_ONBOARDING_FEATURE;