"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNodeItem = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _icon_renderer = require("../icon_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fixIconOffset(node) {
  var _node$icon;
  const offset = (0, _icon_renderer.getIconOffset)(node.icon) || {
    x: 0,
    y: 0
  };
  const finalOffset = {
    x: offset.x / 2,
    y: offset.y / 2
  };
  // Maki icons need to be offset a little bit more on the right (~0.5px)
  if (((_node$icon = node.icon) === null || _node$icon === void 0 ? void 0 : _node$icon.package) === 'maki') {
    finalOffset.x += 0.5;
  }
  return finalOffset;
}
const SelectedNodeItem = ({
  node,
  isHighlighted,
  onSelectedFieldClick,
  onDeselectNode
}) => {
  const fieldClasses = (0, _classnames.default)('gphSelectionList__field', {
    ['gphSelectionList__field--selected']: isHighlighted
  });
  const offset = fixIconOffset(node);
  return /*#__PURE__*/_react.default.createElement("div", {
    "aria-hidden": "true",
    className: fieldClasses,
    onClick: () => onSelectedFieldClick(node)
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "24",
    height: "24"
  }, /*#__PURE__*/_react.default.createElement("circle", {
    className: "gphNode__circle",
    r: "10",
    cx: "12",
    cy: "12",
    style: {
      fill: node.color
    },
    onClick: () => onDeselectNode(node),
    "data-test-subj": `graph-selected-${node.label}`
  }), /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
    color: node.color,
    icon: node.icon,
    className: "gphSelectionList__icon",
    x: offset.x,
    y: offset.y
  })), /*#__PURE__*/_react.default.createElement("span", null, node.label), node.numChildren > 0 && /*#__PURE__*/_react.default.createElement("span", null, " (+", node.numChildren, ")"));
};
exports.SelectedNodeItem = SelectedNodeItem;