"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _url_template = require("../../helpers/url_template");
var _selection_tool_bar = require("./selection_tool_bar");
var _control_panel_tool_bar = require("./control_panel_tool_bar");
var _select_style = require("./select_style");
var _selected_node_editor = require("./selected_node_editor");
var _merge_candidates = require("./merge_candidates");
var _drill_downs = require("./drill_downs");
var _drill_down_icon_links = require("./drill_down_icon_links");
var _state_management = require("../../state_management");
var _selected_node_item = require("./selected_node_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ControlPanelComponent = ({
  workspace,
  liveResponseFields,
  urlTemplates,
  control,
  selectedNode,
  colors,
  mergeCandidates,
  onSetControl,
  selectSelected
}) => {
  const hasNodes = workspace.nodes.length === 0;
  const openUrlTemplate = template => {
    const url = template.url;
    const newUrl = url.replace(_url_template.urlTemplateRegex, template.encoder.encode(workspace));
    window.open(newUrl, '_blank');
  };
  const onSelectedFieldClick = node => {
    selectSelected(node);
    workspace.changeHandler();
  };
  const onDeselectNode = node => {
    workspace.deselectNode(node);
    workspace.changeHandler();
    onSetControl('none');
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "sidebar",
    className: "gphSidebar"
  }, /*#__PURE__*/_react.default.createElement(_control_panel_tool_bar.ControlPanelToolBar, {
    workspace: workspace,
    liveResponseFields: liveResponseFields,
    onSetControl: onSetControl
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__header"
  }, _i18n.i18n.translate('xpack.graph.sidebar.selectionsTitle', {
    defaultMessage: 'Selections'
  })), /*#__PURE__*/_react.default.createElement(_selection_tool_bar.SelectionToolBar, {
    workspace: workspace,
    onSetControl: onSetControl
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSelectionList"
  }, workspace.selectedNodes.length === 0 && /*#__PURE__*/_react.default.createElement("p", {
    className: "help-block"
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.noSelectionsHelpText', {
    defaultMessage: 'No selections. Click on vertices to add.'
  })), workspace.selectedNodes.map(node => /*#__PURE__*/_react.default.createElement(_selected_node_item.SelectedNodeItem, {
    key: node.id,
    node: node,
    isHighlighted: selectedNode === node,
    onSelectedFieldClick: onSelectedFieldClick,
    onDeselectNode: onDeselectNode
  })))), /*#__PURE__*/_react.default.createElement(_drill_down_icon_links.DrillDownIconLinks, {
    urlTemplates: urlTemplates,
    hasNodes: hasNodes,
    openUrlTemplate: openUrlTemplate
  }), control === 'drillDowns' && /*#__PURE__*/_react.default.createElement(_drill_downs.DrillDowns, {
    urlTemplates: urlTemplates,
    openUrlTemplate: openUrlTemplate
  }), control === 'style' && workspace.selectedNodes.length > 0 && /*#__PURE__*/_react.default.createElement(_select_style.SelectStyle, {
    workspace: workspace,
    colors: colors
  }), control === 'editLabel' && selectedNode && /*#__PURE__*/_react.default.createElement(_selected_node_editor.SelectedNodeEditor, {
    workspace: workspace,
    selectedNode: selectedNode
  }), control === 'mergeTerms' && /*#__PURE__*/_react.default.createElement(_merge_candidates.MergeCandidates, {
    workspace: workspace,
    mergeCandidates: mergeCandidates,
    onSetControl: onSetControl
  }));
};
const ControlPanel = (0, _reactRedux.connect)(state => ({
  urlTemplates: (0, _state_management.templatesSelector)(state),
  liveResponseFields: (0, _state_management.liveResponseFieldsSelector)(state)
}))(ControlPanelComponent);
exports.ControlPanel = ControlPanel;