"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatePackageRequestSchemaDeprecated = exports.UpdatePackageRequestSchema = exports.ReauthorizeTransformRequestSchema = exports.InstallPackageFromRegistryRequestSchemaDeprecated = exports.InstallPackageFromRegistryRequestSchema = exports.InstallPackageByUploadRequestSchema = exports.GetStatsRequestSchema = exports.GetPackagesRequestSchema = exports.GetLimitedPackagesRequestSchema = exports.GetInstalledPackagesRequestSchema = exports.GetInputsRequestSchema = exports.GetInfoRequestSchemaDeprecated = exports.GetInfoRequestSchema = exports.GetFileRequestSchema = exports.GetDataStreamsRequestSchema = exports.GetCategoriesRequestSchema = exports.GetBulkAssetsRequestSchema = exports.DeletePackageRequestSchemaDeprecated = exports.DeletePackageRequestSchema = exports.CreateCustomIntegrationRequestSchema = exports.BulkInstallPackagesFromRegistryRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetCategoriesRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    experimental: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    // deprecated
    include_policy_templates: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.GetCategoriesRequestSchema = GetCategoriesRequestSchema;
const GetPackagesRequestSchema = {
  query: _configSchema.schema.object({
    category: _configSchema.schema.maybe(_configSchema.schema.string()),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    experimental: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    // deprecated
    excludeInstallStatus: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    }))
  })
};
exports.GetPackagesRequestSchema = GetPackagesRequestSchema;
const GetInstalledPackagesRequestSchema = {
  query: _configSchema.schema.object({
    dataStreamType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])),
    nameQuery: _configSchema.schema.maybe(_configSchema.schema.string()),
    searchAfter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))),
    perPage: _configSchema.schema.number({
      defaultValue: 15
    }),
    sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
      defaultValue: 'asc'
    })
  })
};
exports.GetInstalledPackagesRequestSchema = GetInstalledPackagesRequestSchema;
const GetDataStreamsRequestSchema = {
  query: _configSchema.schema.object({
    type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])),
    datasetQuery: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
      defaultValue: 'asc'
    }),
    uncategorisedOnly: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
exports.GetDataStreamsRequestSchema = GetDataStreamsRequestSchema;
const GetLimitedPackagesRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.GetLimitedPackagesRequestSchema = GetLimitedPackagesRequestSchema;
const GetFileRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string(),
    filePath: _configSchema.schema.string()
  })
};
exports.GetFileRequestSchema = GetFileRequestSchema;
const GetInfoRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    ignoreUnverified: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    full: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.GetInfoRequestSchema = GetInfoRequestSchema;
const GetBulkAssetsRequestSchema = {
  body: _configSchema.schema.object({
    assetIds: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      type: _configSchema.schema.string()
    }))
  })
};
exports.GetBulkAssetsRequestSchema = GetBulkAssetsRequestSchema;
const GetInfoRequestSchemaDeprecated = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    ignoreUnverified: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    full: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.GetInfoRequestSchemaDeprecated = GetInfoRequestSchemaDeprecated;
const UpdatePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  body: _configSchema.schema.object({
    keepPoliciesUpToDate: _configSchema.schema.boolean()
  })
};
exports.UpdatePackageRequestSchema = UpdatePackageRequestSchema;
const UpdatePackageRequestSchemaDeprecated = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    keepPoliciesUpToDate: _configSchema.schema.boolean()
  })
};
exports.UpdatePackageRequestSchemaDeprecated = UpdatePackageRequestSchemaDeprecated;
const GetStatsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string()
  })
};
exports.GetStatsRequestSchema = GetStatsRequestSchema;
const InstallPackageFromRegistryRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    ignoreMappingUpdateErrors: _configSchema.schema.boolean({
      defaultValue: false
    }),
    skipDataStreamRollover: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean({
      defaultValue: false
    }),
    ignore_constraints: _configSchema.schema.boolean({
      defaultValue: false
    })
  }))
};
exports.InstallPackageFromRegistryRequestSchema = InstallPackageFromRegistryRequestSchema;
const ReauthorizeTransformRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }),
  body: _configSchema.schema.object({
    transforms: _configSchema.schema.arrayOf(_configSchema.schema.object({
      transformId: _configSchema.schema.string()
    }))
  })
};
exports.ReauthorizeTransformRequestSchema = ReauthorizeTransformRequestSchema;
const InstallPackageFromRegistryRequestSchemaDeprecated = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    ignoreMappingUpdateErrors: _configSchema.schema.boolean({
      defaultValue: false
    }),
    skipDataStreamRollover: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean()
  }))
};
exports.InstallPackageFromRegistryRequestSchemaDeprecated = InstallPackageFromRegistryRequestSchemaDeprecated;
const BulkInstallPackagesFromRegistryRequestSchema = {
  query: _configSchema.schema.object({
    prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }),
  body: _configSchema.schema.object({
    packages: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({
      name: _configSchema.schema.string(),
      version: _configSchema.schema.string(),
      prerelease: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })]), {
      minSize: 1
    }),
    force: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
exports.BulkInstallPackagesFromRegistryRequestSchema = BulkInstallPackagesFromRegistryRequestSchema;
const InstallPackageByUploadRequestSchema = {
  query: _configSchema.schema.object({
    ignoreMappingUpdateErrors: _configSchema.schema.boolean({
      defaultValue: false
    }),
    skipDataStreamRollover: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  body: _configSchema.schema.buffer()
};
exports.InstallPackageByUploadRequestSchema = InstallPackageByUploadRequestSchema;
const CreateCustomIntegrationRequestSchema = {
  body: _configSchema.schema.object({
    integrationName: _configSchema.schema.string(),
    datasets: _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      type: _configSchema.schema.oneOf([_configSchema.schema.literal('logs'), _configSchema.schema.literal('metrics'), _configSchema.schema.literal('traces'), _configSchema.schema.literal('synthetics'), _configSchema.schema.literal('profiling')])
    })),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
exports.CreateCustomIntegrationRequestSchema = CreateCustomIntegrationRequestSchema;
const DeletePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }),
  // body is deprecated on delete request
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean()
  }))
};
exports.DeletePackageRequestSchema = DeletePackageRequestSchema;
const DeletePackageRequestSchemaDeprecated = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean()
  }))
};
exports.DeletePackageRequestSchemaDeprecated = DeletePackageRequestSchemaDeprecated;
const GetInputsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.oneOf([_configSchema.schema.literal('json'), _configSchema.schema.literal('yml'), _configSchema.schema.literal('yaml')], {
      defaultValue: 'json'
    })
  })
};
exports.GetInputsRequestSchema = GetInputsRequestSchema;