"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateInputs = getTemplateInputs;
exports.templatePackagePolicyToFullInputs = void 0;
var _lodash = require("lodash");
var _jsYaml = require("js-yaml");
var _package_to_package_policy = require("../../../../common/services/package_to_package_policy");
var _package_policy = require("../../package_policy");
var _full_agent_policy_to_yaml = require("../../../../common/services/full_agent_policy_to_yaml");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Function based off storedPackagePolicyToAgentInputs, it only creates the `streams` section instead of the FullAgentPolicyInput
const templatePackagePolicyToFullInputs = packagePolicyInputs => {
  const fullInputs = [];
  if (!packagePolicyInputs || packagePolicyInputs.length === 0) return fullInputs;
  packagePolicyInputs.forEach(input => {
    const fullInput = {
      ...(input.compiled_input || {}),
      ...(input.streams.length ? {
        streams: input.streams.map(stream => {
          const fullStream = {
            id: stream.id,
            type: input.type,
            data_stream: stream.data_stream,
            ...stream.compiled_stream,
            ...Object.entries(stream.config || {}).reduce((acc, [key, {
              value
            }]) => {
              acc[key] = value;
              return acc;
            }, {})
          };
          return fullStream;
        })
      } : {})
    };

    // deeply merge the input.config values with the full policy input
    (0, _lodash.merge)(fullInput, Object.entries(input.config || {}).reduce((acc, [key, {
      value
    }]) => {
      acc[key] = value;
      return acc;
    }, {}));
    fullInputs.push(fullInput);
  });
  return fullInputs;
};
exports.templatePackagePolicyToFullInputs = templatePackagePolicyToFullInputs;
async function getTemplateInputs(soClient, pkgName, pkgVersion, format) {
  const packageInfoMap = new Map();
  let packageInfo;
  if (packageInfoMap.has(pkgName)) {
    packageInfo = packageInfoMap.get(pkgName);
  } else {
    packageInfo = await (0, _.getPackageInfo)({
      savedObjectsClient: soClient,
      pkgName,
      pkgVersion
    });
  }
  const emptyPackagePolicy = (0, _package_to_package_policy.packageToPackagePolicy)(packageInfo, '');
  const inputsWithStreamIds = (0, _package_policy.getInputsWithStreamIds)(emptyPackagePolicy, undefined, true);
  const compiledInputs = await (0, _package_policy._compilePackagePolicyInputs)(packageInfo, emptyPackagePolicy.vars || {}, inputsWithStreamIds);
  const packagePolicyWithInputs = {
    ...emptyPackagePolicy,
    inputs: compiledInputs
  };
  const fullAgentPolicyInputs = templatePackagePolicyToFullInputs(packagePolicyWithInputs.inputs);
  // @ts-ignore-next-line The return type is any because in some case we can have compiled_input instead of input.streams
  // we don't know what it is. An example is integration APM
  const inputs = fullAgentPolicyInputs.flatMap(input => (input === null || input === void 0 ? void 0 : input.streams) || input);
  if (format === 'json') {
    return {
      inputs
    };
  } else if (format === 'yml') {
    const yaml = (0, _jsYaml.safeDump)({
      inputs
    }, {
      skipInvalid: true,
      sortKeys: _full_agent_policy_to_yaml._sortYamlKeys
    });
    return yaml;
  }
  return {
    inputs: []
  };
}