"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDestinationIndexAliases = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isTransformAliasSetting(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['alias']) && typeof arg.alias === 'string';
}
const getDestinationIndexAliases = aliasSettings => {
  let aliases = [];
  if (!aliasSettings) return aliases;
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(aliasSettings)) {
    Object.keys(aliasSettings).forEach(alias => {
      if (aliasSettings.hasOwnProperty(alias) && typeof alias === 'string') {
        var _aliasSettings$alias;
        const moveOnCreation = ((_aliasSettings$alias = aliasSettings[alias]) === null || _aliasSettings$alias === void 0 ? void 0 : _aliasSettings$alias.move_on_creation) === true;
        aliases.push({
          alias,
          move_on_creation: moveOnCreation
        });
      }
    });
  }
  if (Array.isArray(aliasSettings)) {
    aliases = aliasSettings.reduce((acc, alias) => {
      if (typeof alias === 'string') {
        acc.push({
          alias,
          move_on_creation: alias.endsWith('.latest') ? true : false
        });
      }
      if (isTransformAliasSetting(alias)) {
        var _alias$move_on_creati;
        acc.push({
          alias: alias.alias,
          move_on_creation: (_alias$move_on_creati = alias.move_on_creation) !== null && _alias$move_on_creati !== void 0 ? _alias$move_on_creati : false
        });
      }
      return acc;
    }, []);
  }
  if (typeof aliasSettings === 'string') {
    aliases = [{
      alias: aliasSettings,
      move_on_creation: aliasSettings.endsWith('.latest') ? true : false
    }];
  }
  return aliases;
};
exports.getDestinationIndexAliases = getDestinationIndexAliases;