"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateOutputToV8100 = exports.migrateOutputEvictionsFromV8100 = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateOutputToV8100 = outputDoc => {
  const updatedOutputDoc = outputDoc;
  if (updatedOutputDoc.attributes.type === 'kafka') {
    updatedOutputDoc.attributes.connection_type = 'plaintext';
  }
  return {
    attributes: updatedOutputDoc.attributes
  };
};
exports.migrateOutputToV8100 = migrateOutputToV8100;
const migrateOutputEvictionsFromV8100 = unknownAttributes => {
  const attributes = unknownAttributes;
  if (attributes.type !== 'kafka') {
    return attributes;
  }
  let updatedAttributes = attributes;
  updatedAttributes = (0, _lodash.omit)(updatedAttributes, ['connection_type']);
  return updatedAttributes;
};
exports.migrateOutputEvictionsFromV8100 = migrateOutputEvictionsFromV8100;