"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = exports.postHealthCheckHandler = void 0;
var _https = _interopRequireDefault(require("https"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _errors = require("../../errors");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // get fleet server health check by host
  router.versioned.post({
    path: _constants2.APP_API_ROUTES.HEALTH_CHECK_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostHealthCheckRequestSchema
    }
  }, postHealthCheckHandler);
};
exports.registerRoutes = registerRoutes;
const postHealthCheckHandler = async (context, request, response) => {
  try {
    const abortController = new AbortController();
    const {
      host
    } = request.body;

    // Sometimes when the host is not online, the request hangs
    // Setting a timeout to abort the request after 5s
    setTimeout(() => {
      abortController.abort();
    }, 5000);
    const res = await (0, _nodeFetch.default)(`${host}/api/status`, {
      headers: {
        accept: '*/*'
      },
      method: 'GET',
      agent: new _https.default.Agent({
        rejectUnauthorized: false
      }),
      signal: abortController.signal
    });
    const bodyRes = await res.json();
    const body = {
      ...bodyRes,
      host
    };
    return response.ok({
      body
    });
  } catch (error) {
    // when the request is aborted, return offline status
    if (error.name === 'AbortError') {
      return response.ok({
        body: {
          name: 'fleet-server',
          status: `OFFLINE`,
          host: request.body.host
        }
      });
    }
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.postHealthCheckHandler = postHealthCheckHandler;