"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../constants");
var _constants2 = require("../../../common/constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readEnrollmentTokens: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneEnrollmentAPIKeyRequestSchema
    }
  }, _handler.getOneEnrollmentApiKeyHandler);
  router.versioned.delete({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteEnrollmentAPIKeyRequestSchema
    }
  }, _handler.deleteEnrollmentApiKeyHandler);
  router.versioned.get({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        readEnrollmentTokens: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetEnrollmentAPIKeysRequestSchema
    }
  }, _handler.getEnrollmentApiKeysHandler);
  router.versioned.post({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostEnrollmentAPIKeyRequestSchema
    }
  }, _handler.postEnrollmentApiKeyHandler);
  router.versioned.get({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.INFO_PATTERN_DEPRECATED,
    fleetAuthz: {
      fleet: {
        readEnrollmentTokens: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneEnrollmentAPIKeyRequestSchema
    }
  }, _handler.getOneEnrollmentApiKeyHandler);
  router.versioned.delete({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.DELETE_PATTERN_DEPRECATED,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteEnrollmentAPIKeyRequestSchema
    }
  }, _handler.deleteEnrollmentApiKeyHandler);
  router.versioned.get({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.LIST_PATTERN_DEPRECATED,
    fleetAuthz: {
      fleet: {
        readEnrollmentTokens: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetEnrollmentAPIKeysRequestSchema
    }
  }, _handler.getEnrollmentApiKeysHandler);
  router.versioned.post({
    path: _constants.ENROLLMENT_API_KEY_ROUTES.CREATE_PATTERN_DEPRECATED,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostEnrollmentAPIKeyRequestSchema
    }
  }, _handler.postEnrollmentApiKeyHandler);
};
exports.registerRoutes = registerRoutes;