"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetSettings = sendGetSettings;
exports.sendPutSettings = sendPutSettings;
exports.useGetSettings = useGetSettings;
exports.useGetSettingsQuery = useGetSettingsQuery;
exports.usePutSettingsMutation = usePutSettingsMutation;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetSettingsQuery(options) {
  return (0, _reactQuery.useQuery)({
    queryKey: ['settings'],
    enabled: options === null || options === void 0 ? void 0 : options.enabled,
    queryFn: () => (0, _use_request.sendRequestForRq)({
      method: 'get',
      path: _services.settingsRoutesService.getInfoPath(),
      version: _constants.API_VERSIONS.public.v1
    })
  });
}
function useGetSettings() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.settingsRoutesService.getInfoPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendGetSettings() {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.settingsRoutesService.getInfoPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function usePutSettingsMutation() {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: sendPutSettings,
    onSuccess: () => {
      queryClient.invalidateQueries(['settings']);
    }
  });
}
function sendPutSettings(body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.settingsRoutesService.getUpdatePath(),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}