"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetStatusProvider = void 0;
exports.useFleetStatus = useFleetStatus;
var _react = _interopRequireWildcard(require("react"));
var _use_config = require("./use_config");
var _use_request = require("./use_request");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetStatusContext = /*#__PURE__*/_react.default.createContext(undefined);
const FleetStatusProvider = ({
  defaultFleetStatus,
  children
}) => {
  const config = (0, _use_config.useConfig)();
  const [forceDisplayInstructions, setForceDisplayInstructions] = (0, _react.useState)(false);
  const [state, setState] = (0, _react.useState)(defaultFleetStatus !== null && defaultFleetStatus !== void 0 ? defaultFleetStatus : {
    enabled: config.agents.enabled,
    isLoading: false,
    isReady: false
  });

  // TODO: Refactor to use react-query
  const sendGetStatus = (0, _react.useCallback)(async function sendGetStatus() {
    try {
      setState(s => ({
        ...s,
        isLoading: true
      }));
      const res = await (0, _use_request.sendGetFleetStatus)();
      if (res.error) {
        throw res.error;
      }
      setState(s => {
        var _res$data$isReady, _res$data, _res$data2, _res$data3;
        return {
          ...s,
          isLoading: false,
          isReady: (_res$data$isReady = (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.isReady) !== null && _res$data$isReady !== void 0 ? _res$data$isReady : false,
          missingRequirements: (_res$data2 = res.data) === null || _res$data2 === void 0 ? void 0 : _res$data2.missing_requirements,
          missingOptionalFeatures: (_res$data3 = res.data) === null || _res$data3 === void 0 ? void 0 : _res$data3.missing_optional_features
        };
      });
    } catch (error) {
      setState(s => ({
        ...s,
        isLoading: false,
        error
      }));
    }
  }, [setState]);
  (0, _react.useEffect)(() => {
    if (!defaultFleetStatus) {
      sendGetStatus();
    }
  }, [sendGetStatus, defaultFleetStatus]);
  const refresh = (0, _react.useCallback)(() => sendGetStatus(), [sendGetStatus]);
  return /*#__PURE__*/_react.default.createElement(FleetStatusContext.Provider, {
    value: {
      ...state,
      refresh,
      forceDisplayInstructions,
      setForceDisplayInstructions
    }
  }, children);
};
exports.FleetStatusProvider = FleetStatusProvider;
function useFleetStatus() {
  const context = (0, _react.useContext)(FleetStatusContext);
  if (!context) {
    throw new Error('FleetStatusContext not set');
  }
  return context;
}