"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAzureArmTemplateUrl = void 0;
var _i18n = require("@kbn/i18n");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARM_TEMPLATE_DEFAULT_ACCOUNT_TYPE = 'single-account';
const useCreateAzureArmTemplateUrl = ({
  enrollmentAPIKey,
  azureArmTemplateProps
}) => {
  var _data$item$fleet_serv, _azureArmTemplateUrl;
  const {
    data,
    isLoading
  } = (0, _use_request.useGetSettings)();
  let isError = false;
  let error;

  // Default fleet server host
  const fleetServerHost = data === null || data === void 0 ? void 0 : (_data$item$fleet_serv = data.item.fleet_server_hosts) === null || _data$item$fleet_serv === void 0 ? void 0 : _data$item$fleet_serv[0];
  if (!fleetServerHost && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noFleetServerHost', {
      defaultMessage: 'No Fleet Server host found'
    });
  }
  if (!enrollmentAPIKey && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noApiKey', {
      defaultMessage: 'No enrollment token found'
    });
  }
  let azureArmTemplateUrl = azureArmTemplateProps === null || azureArmTemplateProps === void 0 ? void 0 : azureArmTemplateProps.templateUrl;
  if ((_azureArmTemplateUrl = azureArmTemplateUrl) !== null && _azureArmTemplateUrl !== void 0 && _azureArmTemplateUrl.includes('ACCOUNT_TYPE')) {
    azureArmTemplateUrl = azureArmTemplateUrl.replace('ACCOUNT_TYPE', (azureArmTemplateProps === null || azureArmTemplateProps === void 0 ? void 0 : azureArmTemplateProps.azureAccountType) || ARM_TEMPLATE_DEFAULT_ACCOUNT_TYPE);
  }
  return {
    isLoading,
    azureArmTemplateUrl,
    isError,
    error
  };
};
exports.useCreateAzureArmTemplateUrl = useCreateAzureArmTemplateUrl;