"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicySummaryLine = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_WIDTH = {
  minWidth: 0
};
const NO_WRAP_WHITE_SPACE = {
  whiteSpace: 'nowrap'
};
const AgentPolicySummaryLine = /*#__PURE__*/(0, _react.memo)(({
  policy,
  agent,
  direction = 'row'
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    name,
    id,
    is_managed: isManaged
  } = policy;
  const revision = agent ? agent.policy_revision : policy.revision;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction,
    gutterSize: direction === 'column' ? 'none' : 's',
    alignItems: "baseline",
    style: MIN_WIDTH,
    responsive: false,
    justifyContent: 'flexStart'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: MIN_WIDTH,
    gutterSize: "s",
    alignItems: "baseline",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: `eui-textTruncate`,
    href: getHref('policy_details', {
      policyId: id
    }),
    title: name || id,
    "data-test-subj": "agentPolicyNameLink"
  }, name || id)), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: "Hosted agent policy",
    content: _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.hostedPolicyTooltip', {
      defaultMessage: 'This policy is managed outside of Fleet. Most actions related to this policy are unavailable.'
    }),
    type: "lock",
    size: "m",
    color: "subdued"
  })))), revision && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    style: NO_WRAP_WHITE_SPACE
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicySummaryLine.revisionNumber",
    defaultMessage: "rev. {revNumber}",
    values: {
      revNumber: revision
    }
  }))));
});
exports.AgentPolicySummaryLine = AgentPolicySummaryLine;