"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicyWithPackagePolicies = useAgentPolicyWithPackagePolicies;
exports.useCloudSecurityIntegration = useCloudSecurityIntegration;
exports.useIsK8sPolicy = useIsK8sPolicy;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _get_template_url_from_package_info = require("../../services/get_template_url_from_package_info");
var _get_template_url_from_agent_policy = require("../../services/get_template_url_from_agent_policy");
var _hooks = require("../../hooks");
var _common = require("../../../common");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Packages that requires custom elastic-agent manifest
const K8S_PACKAGES = new Set([_common.FLEET_KUBERNETES_PACKAGE, _common.FLEET_CLOUD_DEFEND_PACKAGE]);
function useAgentPolicyWithPackagePolicies(policyId) {
  const [agentPolicyWithPackagePolicies, setAgentPolicy] = (0, _react.useState)(null);
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  (0, _react.useEffect)(() => {
    async function loadPolicy(policyIdToLoad) {
      if (!policyIdToLoad) {
        return;
      }
      try {
        const agentPolicyRequest = await (0, _hooks.sendGetOneAgentPolicy)(policyIdToLoad);
        setAgentPolicy(agentPolicyRequest.data ? agentPolicyRequest.data.item : null);
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.loadPolicyErrorMessage', {
            defaultMessage: 'An error happened while loading the policy'
          })
        });
      }
    }
    loadPolicy(policyId);
  }, [policyId, notifications.toasts]);
  return {
    agentPolicyWithPackagePolicies
  };
}
function useIsK8sPolicy(agentPolicy) {
  const [isK8s, setIsK8s] = (0, _react.useState)('IS_LOADING');
  (0, _react.useEffect)(() => {
    async function checkifK8s() {
      if (!agentPolicy) {
        setIsK8s('IS_LOADING');
        return;
      }
      setIsK8s(agentPolicy.package_policies.some(isK8sPackage) ? 'IS_KUBERNETES' : 'IS_NOT_KUBERNETES');
    }
    checkifK8s();
  }, [agentPolicy]);
  return {
    isK8s
  };
}
function useCloudSecurityIntegration(agentPolicy) {
  var _cloudSecurityPackage;
  const cloudSecurityPackagePolicy = (0, _react.useMemo)(() => {
    return getCloudSecurityPackagePolicyFromAgentPolicy(agentPolicy);
  }, [agentPolicy]);
  const integrationVersion = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage = cloudSecurityPackagePolicy.package) === null || _cloudSecurityPackage === void 0 ? void 0 : _cloudSecurityPackage.version;

  // Fetch the package info to get the CloudFormation template URL only
  // if the package policy is a Cloud Security policy
  const {
    data: packageInfoData,
    isLoading
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(_common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE, integrationVersion, {
    full: true
  }, {
    enabled: Boolean(cloudSecurityPackagePolicy)
  });
  const AWS_ACCOUNT_TYPE = 'aws.account_type';
  const AZURE_ACCOUNT_TYPE = 'azure.account_type';
  const cloudSecurityIntegration = (0, _react.useMemo)(() => {
    var _cloudSecurityPackage2, _cloudSecurityPackage3, _cloudSecurityPackage4, _cloudSecurityPackage5, _cloudSecurityPackage6, _cloudSecurityPackage7, _cloudSecurityPackage8, _cloudSecurityPackage9, _cloudSecurityPackage10, _cloudSecurityPackage11, _cloudSecurityPackage12, _cloudSecurityPackage13, _cloudSecurityPackage14, _cloudSecurityPackage15;
    if (!agentPolicy || !cloudSecurityPackagePolicy) {
      return undefined;
    }
    const integrationType = (_cloudSecurityPackage2 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage2 === void 0 ? void 0 : (_cloudSecurityPackage3 = _cloudSecurityPackage2.find(input => input.enabled)) === null || _cloudSecurityPackage3 === void 0 ? void 0 : _cloudSecurityPackage3.policy_template;
    if (!integrationType) return undefined;
    const cloudFormationTemplateFromAgentPolicy = (0, _services.getTemplateUrlFromAgentPolicy)(_get_template_url_from_agent_policy.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG.CLOUD_FORMATION, agentPolicy);
    const azureArmTemplateFromAgentPolicy = (0, _services.getTemplateUrlFromAgentPolicy)(_get_template_url_from_agent_policy.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG.ARM_TEMPLATE, agentPolicy);

    // Use the latest CloudFormation template for the current version
    // So it guarantee that the template version matches the integration version
    // when the integration is upgraded.
    // In case it can't find the template for the current version,
    // it will fallback to the one from the agent policy.
    const cloudFormationTemplateUrl = packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item ? (0, _services.getTemplateUrlFromPackageInfo)(packageInfoData.item, integrationType, _get_template_url_from_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION) : cloudFormationTemplateFromAgentPolicy;
    const cloudFormationAwsAccountType = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage4 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage4 === void 0 ? void 0 : (_cloudSecurityPackage5 = _cloudSecurityPackage4.find(input => input.enabled)) === null || _cloudSecurityPackage5 === void 0 ? void 0 : (_cloudSecurityPackage6 = _cloudSecurityPackage5.streams) === null || _cloudSecurityPackage6 === void 0 ? void 0 : (_cloudSecurityPackage7 = _cloudSecurityPackage6[0]) === null || _cloudSecurityPackage7 === void 0 ? void 0 : (_cloudSecurityPackage8 = _cloudSecurityPackage7.vars) === null || _cloudSecurityPackage8 === void 0 ? void 0 : (_cloudSecurityPackage9 = _cloudSecurityPackage8[AWS_ACCOUNT_TYPE]) === null || _cloudSecurityPackage9 === void 0 ? void 0 : _cloudSecurityPackage9.value;
    const azureArmTemplateUrl = packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item ? (0, _services.getTemplateUrlFromPackageInfo)(packageInfoData.item, integrationType, _get_template_url_from_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.ARM_TEMPLATE) : azureArmTemplateFromAgentPolicy;
    const azureArmTemplateAccountType = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage10 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage10 === void 0 ? void 0 : (_cloudSecurityPackage11 = _cloudSecurityPackage10.find(input => input.enabled)) === null || _cloudSecurityPackage11 === void 0 ? void 0 : (_cloudSecurityPackage12 = _cloudSecurityPackage11.streams) === null || _cloudSecurityPackage12 === void 0 ? void 0 : (_cloudSecurityPackage13 = _cloudSecurityPackage12[0]) === null || _cloudSecurityPackage13 === void 0 ? void 0 : (_cloudSecurityPackage14 = _cloudSecurityPackage13.vars) === null || _cloudSecurityPackage14 === void 0 ? void 0 : (_cloudSecurityPackage15 = _cloudSecurityPackage14[AZURE_ACCOUNT_TYPE]) === null || _cloudSecurityPackage15 === void 0 ? void 0 : _cloudSecurityPackage15.value;
    const cloudShellUrl = (0, _services.getCloudShellUrlFromAgentPolicy)(agentPolicy);
    return {
      isLoading,
      integrationType,
      isCloudFormation: Boolean(cloudFormationTemplateFromAgentPolicy),
      cloudFormationProps: {
        awsAccountType: cloudFormationAwsAccountType,
        templateUrl: cloudFormationTemplateUrl
      },
      isAzureArmTemplate: Boolean(azureArmTemplateFromAgentPolicy),
      azureArmTemplateProps: {
        azureAccountType: azureArmTemplateAccountType,
        templateUrl: azureArmTemplateUrl
      },
      cloudShellUrl
    };
  }, [agentPolicy, packageInfoData === null || packageInfoData === void 0 ? void 0 : packageInfoData.item, isLoading, cloudSecurityPackagePolicy]);
  return {
    cloudSecurityIntegration
  };
}
const isK8sPackage = pkg => {
  var _pkg$package;
  const name = (_pkg$package = pkg.package) === null || _pkg$package === void 0 ? void 0 : _pkg$package.name;
  return K8S_PACKAGES.has(name);
};
const getCloudSecurityPackagePolicyFromAgentPolicy = agentPolicy => {
  var _agentPolicy$package_;
  return agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.find(input => {
    var _input$package;
    return ((_input$package = input.package) === null || _input$package === void 0 ? void 0 : _input$package.name) === _common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE;
  });
};