"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingData = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _use_get_agent_incoming_data = require("./use_get_agent_incoming_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmIncomingData = ({
  agentIds,
  installedPolicy,
  agentDataConfirmed,
  setAgentDataConfirmed,
  troubleshootLink
}) => {
  const {
    incomingData,
    isLoading
  } = (0, _use_get_agent_incoming_data.usePollingIncomingData)(agentIds);
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(installedPolicy === null || installedPolicy === void 0 ? void 0 : installedPolicy.name);
  const {
    guidedOnboarding
  } = (0, _hooks.useStartServices)();
  const {
    enrolledAgents,
    numAgentsWithData,
    linkButton,
    message
  } = (0, _use_get_agent_incoming_data.useGetAgentIncomingData)(incomingData, installedPolicy);
  if (!isLoading && enrolledAgents > 0 && numAgentsWithData > 0) {
    setAgentDataConfirmed(true);
    if (installedPolicy !== null && installedPolicy !== void 0 && installedPolicy.name && isGuidedOnboardingActive) {
      var _guidedOnboarding$gui;
      guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui === void 0 ? void 0 : _guidedOnboarding$gui.completeGuidedOnboardingForIntegration(installedPolicy.name);
    }
  }
  if (!agentDataConfirmed) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.confirmIncomingData.loading",
      defaultMessage: "It may take a few minutes for data to arrive in Elasticsearch. If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you\u2019re having trouble, see our {link}. You may close this dialog and check later by viewing your integration assets.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: troubleshootLink
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.enrollmentInstructions.troubleshootingLink",
          defaultMessage: "troubleshooting guide"
        }))
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "IncomingDataConfirmedCallOut",
    title: _i18n.i18n.translate('xpack.fleet.confirmIncomingData.title', {
      defaultMessage: 'Incoming data received from {numAgentsWithData} of {enrolledAgents} recently enrolled { enrolledAgents, plural, one {agent} other {agents}}.',
      values: {
        numAgentsWithData,
        enrolledAgents
      }
    }),
    color: "success",
    iconType: "check"
  }), installedPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: linkButton.href,
    isDisabled: isLoading,
    color: "primary",
    fill: true,
    "data-test-subj": "IncomingDataConfirmedButton"
  }, linkButton.text)));
};
exports.ConfirmIncomingData = ConfirmIncomingData;