"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureArmTemplateInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _azure_arm_template_guide = require("../azure_arm_template_guide");
var _use_create_azure_arm_template_url = require("../../hooks/use_create_azure_arm_template_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AzureArmTemplateInstructions = ({
  enrollmentAPIKey,
  cloudSecurityIntegration,
  agentPolicy
}) => {
  var _cloudSecurityIntegra;
  const {
    isLoading,
    azureArmTemplateUrl,
    error,
    isError
  } = (0, _use_create_azure_arm_template_url.useCreateAzureArmTemplateUrl)({
    enrollmentAPIKey,
    azureArmTemplateProps: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.azureArmTemplateProps
  });
  if (error && isError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: error,
      color: "danger",
      iconType: "error"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "m",
    isLoading: isLoading || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.isLoading),
    contentAriaLabel: _i18n.i18n.translate('xpack.fleet.agentEnrollment.azureArmTemplate.loadingAriaLabel', {
      defaultMessage: 'Loading ARM Template instructions'
    })
  }, /*#__PURE__*/_react.default.createElement(_azure_arm_template_guide.AzureArmTemplateGuide, {
    azureAccountType: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : (_cloudSecurityIntegra = cloudSecurityIntegration.azureArmTemplateProps) === null || _cloudSecurityIntegra === void 0 ? void 0 : _cloudSecurityIntegra.azureAccountType,
    agentPolicy: agentPolicy,
    enrollmentToken: enrollmentAPIKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    fullWidth: true,
    href: azureArmTemplateUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.azureArmTemplate.launchButton",
    defaultMessage: "Launch ARM Template"
  })));
};
exports.AzureArmTemplateInstructions = AzureArmTemplateInstructions;