"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectCreateAgentPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _components = require("../../applications/fleet/sections/agents/components");
var _components2 = require("../../applications/fleet/sections/agent_policy/components");
var _services = require("../../services");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectCreateAgentPolicy = ({
  agentPolicies,
  excludeFleetServer,
  setSelectedPolicyId,
  selectedPolicyId,
  withKeySelection,
  selectedApiKeyId,
  onKeyChange,
  isFleetServerPolicy,
  refreshAgentPolicies
}) => {
  const regularAgentPolicies = (0, _react.useMemo)(() => {
    return agentPolicies.filter(policy => policy && !policy.is_managed && (!excludeFleetServer || !policy.is_default_fleet_server));
  }, [agentPolicies, excludeFleetServer]);
  (0, _react.useEffect)(() => {
    // Select default value if policy has no fleet server
    if (regularAgentPolicies.length === 1 && !selectedPolicyId && excludeFleetServer !== false && !(0, _services.policyHasFleetServer)(regularAgentPolicies[0])) {
      setSelectedPolicyId(regularAgentPolicies[0].id);
    }
  }, [regularAgentPolicies, selectedPolicyId, setSelectedPolicyId, excludeFleetServer]);
  const onAgentPolicyChange = (0, _react.useCallback)(async (key, policy) => {
    if (policy) {
      refreshAgentPolicies();
    }
  }, [refreshAgentPolicies]);
  const [showCreatePolicy, setShowCreatePolicy] = (0, _react.useState)(regularAgentPolicies.length === 0);
  const [createState, setCreateState] = (0, _react.useState)({
    status: _components.CREATE_STATUS.INITIAL
  });
  const [newName, setNewName] = (0, _react.useState)((0, _services.incrementPolicyName)(regularAgentPolicies, isFleetServerPolicy));
  (0, _react.useEffect)(() => {
    setShowCreatePolicy(regularAgentPolicies.length === 0 && !selectedPolicyId);
    setNewName((0, _services.incrementPolicyName)(regularAgentPolicies, isFleetServerPolicy));
  }, [regularAgentPolicies, isFleetServerPolicy, selectedPolicyId]);
  const onAgentPolicyCreated = (0, _react.useCallback)(async (policy, errorMessage) => {
    if (!policy) {
      setCreateState({
        status: _components.CREATE_STATUS.FAILED,
        errorMessage
      });
      return;
    }
    setShowCreatePolicy(false);
    setCreateState({
      status: _components.CREATE_STATUS.CREATED
    });
    if (onAgentPolicyChange) {
      onAgentPolicyChange(policy.id, policy);
    }
    setSelectedPolicyId(policy.id);
  }, [setSelectedPolicyId, onAgentPolicyChange]);
  const onClickCreatePolicy = () => {
    setCreateState({
      status: _components.CREATE_STATUS.INITIAL
    });
    setShowCreatePolicy(true);
    if (withKeySelection && onKeyChange) {
      onKeyChange(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCreatePolicy ? /*#__PURE__*/_react.default.createElement(_components2.AgentPolicyCreateInlineForm, {
    updateAgentPolicy: onAgentPolicyCreated,
    isFleetServerPolicy: isFleetServerPolicy,
    agentPolicyName: newName
  }) : /*#__PURE__*/_react.default.createElement(_.AgentPolicySelection, {
    agentPolicies: regularAgentPolicies,
    withKeySelection: withKeySelection,
    selectedApiKeyId: selectedApiKeyId,
    onKeyChange: onKeyChange,
    excludeFleetServer: excludeFleetServer,
    onClickCreatePolicy: onClickCreatePolicy,
    selectedPolicyId: selectedPolicyId,
    setSelectedPolicyId: setSelectedPolicyId,
    isFleetServerPolicy: isFleetServerPolicy
  }), createState.status !== _components.CREATE_STATUS.INITIAL && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyCreatedCallOut, {
    createState: createState
  }));
};
exports.SelectCreateAgentPolicy = SelectCreateAgentPolicy;