"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedAgentAuthenticationSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../applications/fleet/constants");
var _hooks = require("../../applications/fleet/hooks");
var _loading = require("../loading");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoEnrollmentKeysCallout = ({
  agentPolicyId,
  onCreateEnrollmentApiKey
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoadingEnrollmentKey, setIsLoadingEnrollmentKey] = (0, _react.useState)(false);
  const onCreateEnrollmentTokenClick = async () => {
    setIsLoadingEnrollmentKey(true);
    if (agentPolicyId) {
      try {
        var _res$data;
        const res = await (0, _hooks.sendCreateEnrollmentAPIKey)({
          policy_id: agentPolicyId
        });
        if (res.error) {
          throw res.error;
        }
        setIsLoadingEnrollmentKey(false);
        if (!((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.item)) {
          return;
        }
        onCreateEnrollmentApiKey(res.data.item);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.newEnrollmentKey.keyCreatedToasts', {
          defaultMessage: 'Enrollment token created'
        }));
      } catch (error) {
        setIsLoadingEnrollmentKey(false);
        notifications.toasts.addError(error, {
          title: 'Error'
        });
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.fleet.enrollmentStepAgentPolicy.noEnrollmentTokensForSelectedPolicyCallout', {
      defaultMessage: 'There are no enrollment tokens for the selected agent policy'
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrenrollmentStepAgentPolicyollment.noEnrollmentTokensForSelectedPolicyCalloutDescription",
    defaultMessage: "You must create and enrollment token in order to enroll agents with this policy"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    isLoading: isLoadingEnrollmentKey,
    fill: true,
    onClick: onCreateEnrollmentTokenClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.setUpAgentsLink",
    defaultMessage: "Create enrollment token"
  })));
};
const AdvancedAgentAuthenticationSettings = ({
  agentPolicyId,
  selectedApiKeyId,
  initialAuthenticationSettingsOpen = false,
  onKeyChange
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [enrollmentAPIKeys, setEnrollmentAPIKeys] = (0, _react.useState)([]);
  const [isAuthenticationSettingsOpen, setIsAuthenticationSettingsOpen] = (0, _react.useState)(initialAuthenticationSettingsOpen);
  (0, _react.useEffect)(() => {
    setIsAuthenticationSettingsOpen(initialAuthenticationSettingsOpen);
  }, [initialAuthenticationSettingsOpen]);
  const [isLoadingEnrollmentApiKeys, setIsLoadingEnrollmentApiKeys] = (0, _react.useState)(false);
  const onCreateEnrollmentApiKey = (0, _react.useCallback)(key => {
    setEnrollmentAPIKeys([key]);
    onKeyChange(key.id);
  }, [onKeyChange]);
  (0, _react.useEffect)(function useEnrollmentKeysForAgentPolicyEffect() {
    if (!agentPolicyId) {
      setIsAuthenticationSettingsOpen(true);
      setEnrollmentAPIKeys([]);
      return;
    }
    async function fetchEnrollmentAPIKeys() {
      try {
        var _enrollmentAPIKeysRes;
        setIsLoadingEnrollmentApiKeys(true);
        const res = await (0, _hooks.sendGetEnrollmentAPIKeys)({
          page: 1,
          perPage: _constants.SO_SEARCH_LIMIT
        });
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching enrollment API keys');
        }
        const enrollmentAPIKeysResponse = res.data.items.filter(key => key.policy_id === agentPolicyId && key.active === true);
        setEnrollmentAPIKeys(enrollmentAPIKeysResponse);
        // Default to the first enrollment key if there is one.
        onKeyChange((_enrollmentAPIKeysRes = enrollmentAPIKeysResponse[0]) === null || _enrollmentAPIKeysRes === void 0 ? void 0 : _enrollmentAPIKeysRes.id);
      } catch (error) {
        notifications.toasts.addError(error, {
          title: 'Error'
        });
      } finally {
        setIsLoadingEnrollmentApiKeys(false);
      }
    }
    fetchEnrollmentAPIKeys();
  }, [onKeyChange, agentPolicyId, notifications.toasts]);
  (0, _react.useEffect)(function useDefaultEnrollmentKeyForAgentPolicyEffect() {
    if (!selectedApiKeyId && enrollmentAPIKeys.length > 0 && enrollmentAPIKeys[0].policy_id === agentPolicyId) {
      const enrollmentAPIKeyId = enrollmentAPIKeys[0].id;
      onKeyChange(enrollmentAPIKeyId);
    }
  }, [enrollmentAPIKeys, selectedApiKeyId, agentPolicyId, onKeyChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    iconType: isAuthenticationSettingsOpen ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsAuthenticationSettingsOpen(!isAuthenticationSettingsOpen)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.showAuthenticationSettingsButton",
    defaultMessage: "Authentication settings"
  })), isAuthenticationSettingsOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), enrollmentAPIKeys.length && selectedApiKeyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: enrollmentAPIKeys.map(key => ({
      value: key.id,
      text: key.name
    })),
    value: selectedApiKeyId || undefined,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentStepAgentPolicy.enrollmentTokenSelectLabel",
      defaultMessage: "Enrollment token"
    })),
    onChange: e => {
      onKeyChange(e.target.value);
    }
  }) : isLoadingEnrollmentApiKeys ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : agentPolicyId ? /*#__PURE__*/_react.default.createElement(NoEnrollmentKeysCallout, {
    agentPolicyId: agentPolicyId,
    onCreateEnrollmentApiKey: onCreateEnrollmentApiKey
  }) : null));
};
exports.AdvancedAgentAuthenticationSettings = AdvancedAgentAuthenticationSettings;