"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParams = exports.categoryExists = exports.EPMHomePage = void 0;
Object.defineProperty(exports, "mapToCard", {
  enumerable: true,
  get: function () {
    return _card_utils.mapToCard;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../constants");
var _layouts = require("../../../../layouts");
var _services = require("../../../../services");
var _hooks = require("../../../../hooks");
var _installed_packages = require("./installed_packages");
var _available_packages = require("./available_packages");
var _card_utils = require("./card_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParams = (params, search) => {
  const {
    category,
    subcategory
  } = params;
  const selectedCategory = category || '';
  const queryParams = new URLSearchParams(search);
  const searchParam = queryParams.get(_constants2.INTEGRATIONS_SEARCH_QUERYPARAM) || '';
  return {
    selectedCategory,
    searchParam,
    selectedSubcategory: subcategory
  };
};
exports.getParams = getParams;
const categoryExists = (category, categories) => {
  return categories.some(c => c.id === category);
};
exports.categoryExists = categoryExists;
const EPMHomePage = () => {
  var _settings$item$prerel;
  const authz = (0, _hooks.useAuthz)();
  const isAuthorizedToFetchSettings = authz.fleet.all;
  const {
    data: settings,
    isFetchedAfterMount: isSettingsFetched
  } = (0, _hooks.useGetSettingsQuery)({
    enabled: isAuthorizedToFetchSettings
  });
  const prereleaseIntegrationsEnabled = (_settings$item$prerel = settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled) !== null && _settings$item$prerel !== void 0 ? _settings$item$prerel : false;
  const shouldFetchPackages = !isAuthorizedToFetchSettings || isSettingsFetched;
  // loading packages to find installed ones
  const {
    data: allPackages,
    isLoading
  } = (0, _hooks.useGetPackagesQuery)({
    prerelease: prereleaseIntegrationsEnabled
  }, {
    enabled: shouldFetchPackages
  });
  const installedPackages = (0, _react.useMemo)(() => ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => pkg.status === _constants.installationStatuses.Installed || pkg.status === _constants.installationStatuses.InstallFailed), [allPackages]);
  const unverifiedPackageCount = (0, _react.useMemo)(() => installedPackages.filter(pkg => {
    var _pkg$installationInfo;
    return ((_pkg$installationInfo = pkg.installationInfo) === null || _pkg$installationInfo === void 0 ? void 0 : _pkg$installationInfo.verification_status) && pkg.installationInfo.verification_status === 'unverified';
  }).length, [installedPackages]);
  const upgradeablePackageCount = (0, _react.useMemo)(() => installedPackages.filter(_services.isPackageUpdatable).length, [installedPackages]);
  const notificationsBySection = {
    manage: unverifiedPackageCount + upgradeablePackageCount
  };
  if (!shouldFetchPackages) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_installed
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "manage",
    notificationsBySection: notificationsBySection
  }, /*#__PURE__*/_react.default.createElement(_installed_packages.InstalledPackages, {
    installedPackages: installedPackages,
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_all
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "browse",
    notificationsBySection: notificationsBySection
  }, /*#__PURE__*/_react.default.createElement(_available_packages.AvailablePackages, {
    prereleaseIntegrationsEnabled: prereleaseIntegrationsEnabled
  }))));
};
exports.EPMHomePage = EPMHomePage;