"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallPkgRouteOptions = void 0;
var _constants = require("../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// List of packages that shouldn't use the multi-step onboarding UI because they use custom policy interfaces
// or are otherwise not accounted for by verbiage and elements throughout the multi-step UI
const EXCLUDED_PACKAGES = ['apm', 'cloud_security_posture', 'cloud_defend', 'dga', 'fleet_server', 'osquery_manager', 'problemchild', 'security_detection_engine', 'synthetics'];
const isPackageExemptFromStepsLayout = pkgkey => EXCLUDED_PACKAGES.some(pkgname => pkgkey.startsWith(pkgname));
/*
 * When the install package button is pressed, this fn decides which page to navigate to
 * by generating the options to be passed to `services.application.navigateToApp`.
 */
const getInstallPkgRouteOptions = ({
  currentPath,
  integration,
  agentPolicyId,
  pkgkey,
  isFirstTimeAgentUser,
  isCloud,
  isExperimentalAddIntegrationPageEnabled,
  isGuidedOnboardingActive
}) => {
  const integrationOpts = integration ? {
    integration
  } : {};
  const packageExemptFromStepsLayout = isPackageExemptFromStepsLayout(pkgkey);
  const useMultiPageLayout = isExperimentalAddIntegrationPageEnabled && isCloud && (isFirstTimeAgentUser || isGuidedOnboardingActive) && !packageExemptFromStepsLayout;
  const path = _constants.pagePathGetters.add_integration_to_policy({
    pkgkey,
    useMultiPageLayout,
    ...integrationOpts,
    ...(agentPolicyId ? {
      agentPolicyId
    } : {})
  })[1];
  let redirectToPath;
  let onSaveQueryParams;
  if (agentPolicyId) {
    redirectToPath = [_constants.PLUGIN_ID, {
      path: _constants.pagePathGetters.policy_details({
        policyId: agentPolicyId
      })[1]
    }];
    onSaveQueryParams = {
      showAddAgentHelp: true,
      openEnrollmentFlyout: true
    };
  } else {
    redirectToPath = [_constants.INTEGRATIONS_PLUGIN_ID, {
      path: _constants.pagePathGetters.integration_details_policies({
        pkgkey,
        ...integrationOpts
      })[1]
    }];
    onSaveQueryParams = {
      showAddAgentHelp: {
        renameKey: 'showAddAgentHelpForPolicyId',
        policyIdAsValue: true
      },
      openEnrollmentFlyout: {
        renameKey: 'addAgentToPolicyId',
        policyIdAsValue: true
      }
    };
  }
  const state = {
    onSaveNavigateTo: redirectToPath,
    onSaveQueryParams,
    onCancelNavigateTo: [_constants.INTEGRATIONS_PLUGIN_ID, {
      path: _constants.pagePathGetters.integration_details_overview({
        pkgkey,
        ...integrationOpts
      })[1]
    }],
    onCancelUrl: currentPath
  };
  return [_constants.PLUGIN_ID, {
    path,
    state
  }];
};
exports.getInstallPkgRouteOptions = getInstallPkgRouteOptions;