"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Configs = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Configs = ({
  packageInfo
}) => {
  const {
    notifications,
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    name: pkgName,
    version: pkgVersion,
    title: pkgTitle
  } = packageInfo;
  const notInstalled = packageInfo.status !== 'installing';
  const {
    data: configs,
    error,
    isLoading
  } = (0, _hooks.useGetInputsTemplatesQuery)({
    pkgName,
    pkgVersion
  }, {
    format: 'yaml'
  });
  if (error) {
    notifications.toasts.addError(error, {
      title: _i18n.i18n.translate('xpack.fleet.epm.InputTemplates.loadingErro', {
        defaultMessage: 'Error input templates'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "epm.Configs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, isLoading && !configs ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.InputTemplates.mainText",
    defaultMessage: "View sample configurations for each of the {name} integration's data streams below. Copy/paste this YML into your {elasticAgentYml} file or into a file within your {inputsDir} directory. For more information, see the {userGuideLink}",
    values: {
      name: pkgTitle,
      elasticAgentYml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent.yml"),
      inputsDir: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "inputs.d"),
      userGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.elasticAgentInputConfiguration,
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.InputTemplates.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }))), notInstalled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.InputTemplates.installCallout",
      defaultMessage: "Install the integration to use the following configs."
    }),
    color: "warning",
    iconType: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    paddingSize: "s",
    overflowHeight: 1000
  }, configs))));
};
exports.Configs = Configs;