"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationButton = AddIntegrationButton;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddIntegrationButton(props) {
  const {
    userCanInstallPackages,
    missingSecurityConfiguration,
    packageName,
    href,
    onClick
  } = props;
  const tooltip = !userCanInstallPackages ? {
    content: missingSecurityConfiguration ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",
      defaultMessage: "To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",
      defaultMessage: "Elastic Agent Integrations require the All privilege for Fleet and All privilege for Integrations. Contact your administrator."
    })
  } : undefined;
  return /*#__PURE__*/_react.default.createElement(_components.EuiButtonWithTooltip, {
    fill: true,
    isDisabled: !userCanInstallPackages,
    iconType: "plusInCircle",
    href: href,
    onClick: e => onClick(e),
    "data-test-subj": "addIntegrationPolicyButton",
    tooltip: tooltip
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.addPackagePolicyButtonText",
    defaultMessage: "Add {packageName}",
    values: {
      packageName
    }
  }));
}