"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/constants");
var _components = require("../../../../../components");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _deferred_assets_accordion = require("./deferred_assets_accordion");
var _assets_accordion = require("./assets_accordion");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetsPage = ({
  packageInfo
}) => {
  const {
    name,
    version
  } = packageInfo;
  const pkgkey = `${name}-${version}`;
  const {
    spaces,
    docLinks
  } = (0, _hooks.useStartServices)();
  const customAssetsExtension = (0, _hooks.useUIExtension)(packageInfo.name, 'package-detail-assets');
  const canReadPackageSettings = (0, _hooks.useAuthz)().integrations.readPackageInfo;
  const {
    getPath
  } = (0, _hooks.useLink)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const packageInstallStatus = getPackageInstallStatus(packageInfo.name);

  // assume assets are installed in this space until we find otherwise
  const [assetsInstalledInCurrentSpace, setAssetsInstalledInCurrentSpace] = (0, _react.useState)(true);
  const [assetSavedObjects, setAssetsSavedObjects] = (0, _react.useState)();
  const [deferredInstallations, setDeferredInstallations] = (0, _react.useState)();
  const [fetchError, setFetchError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const fetchAssetSavedObjects = async () => {
      if ('installationInfo' in packageInfo) {
        if (spaces) {
          var _packageInfo$installa;
          const {
            id: spaceId
          } = await spaces.getActiveSpace();
          const assetInstallSpaceId = (_packageInfo$installa = packageInfo.installationInfo) === null || _packageInfo$installa === void 0 ? void 0 : _packageInfo$installa.installed_kibana_space_id;

          // if assets are installed in a different space no need to attempt to load them.
          if (assetInstallSpaceId && assetInstallSpaceId !== spaceId) {
            setAssetsInstalledInCurrentSpace(false);
            setIsLoading(false);
            return;
          }
        }
        const pkgInstallationInfo = packageInfo.installationInfo;
        if (pkgInstallationInfo !== null && pkgInstallationInfo !== void 0 && pkgInstallationInfo.installed_es && Array.isArray(pkgInstallationInfo.installed_es) && pkgInstallationInfo.installed_es.length > 0) {
          const deferredAssets = pkgInstallationInfo.installed_es.filter(asset => asset.deferred === true);
          setDeferredInstallations(deferredAssets);
        }
        const authorizedTransforms = ((pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_es) || []).filter(asset => asset.type === _types.ElasticsearchAssetType.transform && !asset.deferred);
        if ((authorizedTransforms === null || authorizedTransforms === void 0 ? void 0 : authorizedTransforms.length) === 0 && (!(pkgInstallationInfo !== null && pkgInstallationInfo !== void 0 && pkgInstallationInfo.installed_kibana) || pkgInstallationInfo.installed_kibana.length === 0)) {
          setIsLoading(false);
          return;
        }
        try {
          var _response$data;
          const assetIds = [...authorizedTransforms, ...((pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_kibana) || [])].map(({
            id,
            type
          }) => ({
            id,
            type
          }));
          const response = await (0, _hooks.sendGetBulkAssets)({
            assetIds
          });
          setAssetsSavedObjects((_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items);
        } catch (e) {
          setFetchError(e);
        } finally {
          setIsLoading(false);
        }
      } else {
        setIsLoading(false);
      }
    };
    fetchAssetSavedObjects();
  }, [packageInfo, spaces]);

  // if they arrive at this page and the package is not installed, send them to overview
  // this happens if they arrive with a direct url or they uninstall while on this tab
  if (packageInstallStatus.status !== _types.InstallStatus.installed) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: getPath('integration_details_overview', {
        pkgkey
      })
    });
  }
  const showDeferredInstallations = Array.isArray(deferredInstallations) && deferredInstallations.length > 0;
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_components.Loading, null);
  } else if (!canReadPackageSettings) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.assetsPermissionErrorTitle",
        defaultMessage: "Permission error"
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.assets.assetsPermissionError",
      defaultMessage: "You do not have permission to retrieve the Kibana saved object for that integration. Contact your administrator."
    }));
  } else if (fetchError) {
    content = /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.fetchAssetsErrorTitle",
        defaultMessage: "Error loading assets"
      }),
      error: fetchError
    });
  } else if (!assetsInstalledInCurrentSpace) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      heading: "h2",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpaceTitle",
        defaultMessage: "Assets not available in this space"
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpaceBody",
      defaultMessage: "This integration is installed, but no assets are available in this space. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.installAndUninstallIntegrationAssets,
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpace.learnMore",
          defaultMessage: "Learn more"
        }))
      }
    })));
  } else if (assetSavedObjects === undefined || assetSavedObjects.length === 0) {
    if (customAssetsExtension) {
      // If a UI extension for custom asset entries is defined, render the custom component here despite
      // there being no saved objects found
      content = /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(customAssetsExtension.Component, null));
    } else {
      content = !showDeferredInstallations ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.noAssetsFoundLabel",
        defaultMessage: "No assets found"
      }))) : null;
    }
  } else {
    content = [..._constants.allowedAssetTypes.map(assetType => {
      const sectionAssetSavedObjects = assetSavedObjects.filter(so => so.type === assetType);
      if (!sectionAssetSavedObjects.length) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: assetType
      }, /*#__PURE__*/_react.default.createElement(_assets_accordion.AssetsAccordion, {
        savedObjects: sectionAssetSavedObjects,
        type: assetType,
        key: assetType
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }));
    }),
    // Ensure we add any custom assets provided via UI extension to the end of the list of other assets
    customAssetsExtension ? /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(customAssetsExtension.Component, null)) : null];
  }
  const deferredInstallationsContent = showDeferredInstallations ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deferred_assets_accordion.DeferredAssetsSection, {
    deferredInstallations: deferredInstallations,
    packageInfo: packageInfo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, deferredInstallationsContent, content));
};
exports.AssetsPage = AssetsPage;