"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _services = require("../../../../services");
var _utils = require("../utils");
var _controls = require("./controls");
var _grid = require("./grid");
var _missing_integrations = require("./missing_integrations");
var _search_box = require("./search_box");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StickySidebar = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  position: sticky;
  top: 120px;
`;
const PackageListGrid = ({
  isLoading,
  controls,
  title,
  list,
  searchTerm,
  setSearchTerm,
  selectedCategory,
  setCategory,
  categories,
  availableSubCategories,
  setSelectedSubCategory,
  selectedSubCategory,
  setUrlandReplaceHistory,
  setUrlandPushHistory,
  showMissingIntegrationMessage = false,
  callout,
  showCardLabels = true
}) => {
  const localSearchRef = (0, _hooks.useLocalSearch)(list, !!isLoading);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const MAX_SUBCATEGORIES_NUMBER = 6;
  const {
    showIntegrationsSubcategories
  } = _services.ExperimentalFeaturesService.get();
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const resetQuery = () => {
    setSearchTerm('');
    setUrlandReplaceHistory({
      searchString: '',
      categoryId: '',
      subCategoryId: ''
    });
  };
  const onSubCategoryClick = (0, _react.useCallback)(subCategory => {
    if (setSelectedSubCategory) setSelectedSubCategory(subCategory);
    setUrlandPushHistory({
      categoryId: selectedCategory,
      subCategoryId: subCategory
    });
  }, [selectedCategory, setSelectedSubCategory, setUrlandPushHistory]);
  const filteredPromotedList = (0, _react.useMemo)(() => {
    if (isLoading) return [];
    const filteredList = searchTerm ? list.filter(item => localSearchRef.current.search(searchTerm).map(match => match[_hooks.searchIdField]).includes(item[_hooks.searchIdField])) : list;
    return (0, _utils.promoteFeaturedIntegrations)(filteredList, selectedCategory);
  }, [isLoading, list, localSearchRef, searchTerm, selectedCategory]);
  const splitSubcategories = subcategories => {
    if (!subcategories) return {};else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) < MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories,
        hiddenSubCategories: []
      };
    } else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) >= MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories.slice(0, MAX_SUBCATEGORIES_NUMBER),
        hiddenSubCategories: subcategories.slice(MAX_SUBCATEGORIES_NUMBER)
      };
    }
    return {};
  };
  const splitSubcat = splitSubcategories(availableSubCategories);
  const {
    visibleSubCategories
  } = splitSubcat;
  const hiddenSubCategoriesItems = (0, _react.useMemo)(() => {
    var _splitSubcat$hiddenSu;
    return splitSubcat === null || splitSubcat === void 0 ? void 0 : (_splitSubcat$hiddenSu = splitSubcat.hiddenSubCategories) === null || _splitSubcat$hiddenSu === void 0 ? void 0 : _splitSubcat$hiddenSu.map(subCategory => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: subCategory.id,
        onClick: () => {
          onSubCategoryClick(subCategory.id);
          closePopover();
        },
        icon: selectedSubCategory === subCategory.id ? 'check' : 'empty'
      }, subCategory.title);
    });
  }, [onSubCategoryClick, selectedSubCategory, splitSubcat === null || splitSubcat === void 0 ? void 0 : splitSubcat.hiddenSubCategories]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexStart",
    gutterSize: "xl",
    "data-test-subj": "epmList.integrationCards"
  }, /*#__PURE__*/_react.default.createElement(StickySidebar, {
    "data-test-subj": "epmList.controlsSideColumn",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_controls.ControlsColumn, {
    controls: controls,
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    "data-test-subj": "epmList.mainColumn",
    style: {
      alignSelf: 'stretch'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_search_box.SearchBox, {
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    selectedCategory: selectedCategory,
    setCategory: setCategory,
    categories: categories,
    availableSubCategories: availableSubCategories,
    setSelectedSubCategory: setSelectedSubCategory,
    selectedSubCategory: selectedSubCategory,
    setUrlandReplaceHistory: setUrlandReplaceHistory
  })), showIntegrationsSubcategories && availableSubCategories !== null && availableSubCategories !== void 0 && availableSubCategories.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null) : null, showIntegrationsSubcategories ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "epmList.subcategoriesRow",
    justifyContent: "flexStart",
    direction: "row",
    gutterSize: "s",
    style: {
      maxWidth: 943
    }
  }, visibleSubCategories === null || visibleSubCategories === void 0 ? void 0 : visibleSubCategories.map(subCategory => {
    const isSelected = subCategory.id === selectedSubCategory;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: subCategory.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      css: isSelected ? 'color: white' : '',
      color: isSelected ? 'accent' : 'text',
      fill: isSelected,
      "aria-label": subCategory === null || subCategory === void 0 ? void 0 : subCategory.title,
      onClick: () => onSubCategoryClick(subCategory.id)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.subcategoriesButton",
      defaultMessage: "{subcategory}",
      values: {
        subcategory: subCategory.title
      }
    })));
  }), hiddenSubCategoriesItems !== null && hiddenSubCategoriesItems !== void 0 && hiddenSubCategoriesItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "epmList.showMoreSubCategoriesButton",
    id: "moreSubCategories",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      onClick: onButtonClick,
      iconType: "boxesHorizontal",
      "aria-label": "Show more subcategories",
      size: "m"
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: hiddenSubCategoriesItems
  }))) : null)) : null, callout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), callout) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_grid.GridColumn, {
    isLoading: !!isLoading,
    list: filteredPromotedList,
    showMissingIntegrationMessage: showMissingIntegrationMessage,
    showCardLabels: showCardLabels
  })), showMissingIntegrationMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_missing_integrations.MissingIntegrationContent, {
    setUrlandPushHistory: setUrlandPushHistory,
    resetQuery: resetQuery,
    setSelectedCategory: setCategory
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.PackageListGrid = PackageListGrid;