"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationPreference = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recommendedTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.integrationPreference.recommendedTooltip",
  defaultMessage: "We recommend Elastic Agent integrations when they are generally available."
});
const Item = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-left: ${props => props.theme.eui.euiSizeXS};
`;
const EuiSwitchNoWrap = (0, _styledComponents.default)(_eui.EuiSwitch)`
  white-space: nowrap;
`;
const options = [{
  type: 'recommended',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.recommendedLabel', {
    defaultMessage: 'Recommended'
  })), /*#__PURE__*/_react.default.createElement(Item, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: recommendedTooltip
  })))
}, {
  type: 'agent',
  label: _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.elasticAgentLabel', {
    defaultMessage: 'Elastic Agent only'
  })
}, {
  type: 'beats',
  label: _i18n.i18n.translate('xpack.fleet.epm.integrationPreference.beatsLabel', {
    defaultMessage: 'Beats only'
  })
}];
const IntegrationPreference = ({
  initialType,
  onChange,
  prereleaseIntegrationsEnabled
}) => {
  const [idSelected, setIdSelected] = _react.default.useState(initialType);
  const [prereleaseIntegrationsChecked, setPrereleaseIntegrationsChecked] = _react.default.useState(undefined);
  const {
    docLinks,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    mutateAsync: mutateSettingsAsync
  } = (0, _hooks.usePutSettingsMutation)();
  const updateSettings = (0, _react.useCallback)(async prerelease => {
    try {
      setPrereleaseIntegrationsChecked(prerelease);
      const res = await mutateSettingsAsync({
        prerelease_integrations_enabled: prerelease
      });
      if (res.error) {
        throw res.error;
      }
    } catch (error) {
      setPrereleaseIntegrationsChecked(!prerelease);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.errorUpdatingSettings', {
          defaultMessage: 'Error updating settings'
        })
      });
    }
  }, [mutateSettingsAsync, notifications.toasts]);
  const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.beatsAgentComparison
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.integrationPreference.titleLink",
    defaultMessage: "Elastic Agent and Beats"
  }));
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.integrationPreference.title",
    defaultMessage: "If an integration is available for {link}, show:",
    values: {
      link
    }
  });
  const radios = options.map(option => ({
    id: option.type,
    value: option.type,
    label: option.label
  }));
  const onPrereleaseSwitchChange = event => {
    updateSettings(event.target.checked);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(EuiSwitchNoWrap, {
    label: "Display beta integrations",
    checked: typeof prereleaseIntegrationsChecked !== 'undefined' ? prereleaseIntegrationsChecked : prereleaseIntegrationsEnabled,
    onChange: onPrereleaseSwitchChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: radios,
    idSelected: idSelected,
    onChange: (id, value) => {
      setIdSelected(id);
      onChange(value);
    },
    name: "preference"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.IntegrationPreference = IntegrationPreference;