"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinks = useLinks;
var _use_core = require("../../../hooks/use_core");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeRelativePath = relativePath => new URL(relativePath, 'http://example.com').pathname;
function useLinks() {
  const {
    http
  } = (0, _use_core.useStartServices)();
  return {
    toSharedAssets: path => http.basePath.prepend(`/plugins/kibanaReact/assets/${path}`),
    toPackageImage: (img, pkgName, pkgVersion) => {
      const sourcePath = img.src ? `/package/${pkgName}/${pkgVersion}${img.src}` : 'path' in img && img.path;
      if (sourcePath) {
        const filePath = _services.epmRouteService.getFilePath(sourcePath);
        return http.basePath.prepend(filePath);
      }
    },
    toRelativeImage: ({
      path,
      packageName,
      version
    }) => {
      const imagePath = removeRelativePath(path);
      const filePath = `${_services.epmRouteService.getInfoPath(packageName, version)}/${imagePath}`;
      return http.basePath.prepend(filePath);
    }
  };
}