"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = useBreadcrumbs;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_BREADCRUMB = {
  href: _constants.pagePathGetters.integrations()[1],
  text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.integrationsAppTitle', {
    defaultMessage: 'Integrations'
  }),
  deepLinkId: 'integrations'
};
const breadcrumbGetters = {
  integrations: () => [BASE_BREADCRUMB],
  integrations_all: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.allIntegrationsPageTitle', {
      defaultMessage: 'Browse integrations'
    })
  }],
  integrations_installed: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.installedIntegrationsPageTitle', {
      defaultMessage: 'Installed integrations'
    })
  }],
  integration_details_overview: ({
    pkgTitle
  }) => [BASE_BREADCRUMB, {
    text: pkgTitle
  }],
  integration_policy_edit: ({
    pkgTitle,
    pkgkey,
    policyName
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.integration_details_policies({
      pkgkey
    })[1],
    text: pkgTitle
  }, {
    text: policyName
  }],
  integration_policy_upgrade: ({
    pkgTitle,
    pkgkey,
    policyName
  }) => [BASE_BREADCRUMB, {
    href: _constants.pagePathGetters.integration_details_policies({
      pkgkey
    })[1],
    text: pkgTitle
  }, {
    text: policyName
  }, {
    text: _i18n.i18n.translate('xpack.fleet.breadcrumbs.upgradePackagePolicyPageTitle', {
      defaultMessage: 'Upgrade integration '
    })
  }]
};
function useBreadcrumbs(page, values = {}) {
  var _breadcrumbGetters$pa;
  const {
    chrome,
    http,
    application
  } = (0, _.useStartServices)();
  const pageRef = (0, _react.useRef)();
  if (pageRef.current === page) {
    return;
  }
  pageRef.current = page;
  const breadcrumbs = ((_breadcrumbGetters$pa = breadcrumbGetters[page]) === null || _breadcrumbGetters$pa === void 0 ? void 0 : _breadcrumbGetters$pa.call(breadcrumbGetters, values).map(breadcrumb => {
    const href = breadcrumb.href ? http.basePath.prepend(`${_constants.INTEGRATIONS_BASE_PATH}${breadcrumb.href}`) : undefined;
    return {
      ...breadcrumb,
      href,
      onClick: href ? ev => {
        ev.preventDefault();
        application.navigateToUrl(href);
      } : undefined
    };
  })) || [];
  const docTitle = [...breadcrumbs].reverse().map(breadcrumb => breadcrumb.text);
  chrome.docTitle.change(docTitle);
  chrome.setBreadcrumbs(breadcrumbs);
}