"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultOutputBadge = exports.DefaultMonitoringOutputBadge = exports.DefaultBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultBadges = /*#__PURE__*/_react.default.memo(({
  output
}) => {
  const badges = (0, _react.useMemo)(() => {
    const badgesArray = [];
    if (output.is_default) {
      badgesArray.push( /*#__PURE__*/_react.default.createElement(DefaultOutputBadge, {
        key: "default-output"
      }));
    }
    if (output.is_default_monitoring) {
      badgesArray.push( /*#__PURE__*/_react.default.createElement(DefaultMonitoringOutputBadge, {
        key: "default-monitoring-output"
      }));
    }
    return badgesArray;
  }, [output]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "xs"
  }, badges.map((badge, idx) => badge));
});
exports.DefaultBadges = DefaultBadges;
const DefaultOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultOutputBadgeTitle",
  defaultMessage: "Agent integrations"
}));
exports.DefaultOutputBadge = DefaultOutputBadge;
const DefaultMonitoringOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",
  defaultMessage: "Agent monitoring"
}));
exports.DefaultMonitoringOutputBadge = DefaultMonitoringOutputBadge;