"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogstashApiKey = useLogstashApiKey;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLogstashApiKey() {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [apiKey, setApiKey] = (0, _react.useState)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const generateApiKey = (0, _react.useCallback)(async () => {
    try {
      var _res$data;
      setIsLoading(true);
      const res = await (0, _hooks.sendPostLogstashApiKeys)();
      if (res.error) {
        throw res.error;
      }
      setApiKey((_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.api_key);
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.logstashInstructions.generateApiKeyError', {
          defaultMessage: 'Impossible to generate an api key'
        })
      });
    } finally {
      setIsLoading(false);
    }
  }, [notifications.toasts]);
  return (0, _react.useMemo)(() => ({
    isLoading,
    generateApiKey,
    apiKey
  }), [isLoading, generateApiKey, apiKey]);
}