"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormRemoteEsSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _multi_row_input = require("../multi_row_input");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormRemoteEsSection = props => {
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage) {
      if (inputs.serviceTokenInput.value && !inputs.serviceTokenSecretInput.value) {
        inputs.serviceTokenSecretInput.setValue(inputs.serviceTokenInput.value);
        inputs.serviceTokenInput.clear();
      }
    }
  }, [useSecretsStorage, inputs.serviceTokenInput, inputs.serviceTokenSecretInput, isFirstLoad, setIsFirstLoad]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.serviceTokenInput.clear();
    } else {
      inputs.serviceTokenSecretInput.setValue('');
    }
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.hostUrlInput",
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel', {
      defaultMessage: 'Hosts'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    })
  }, inputs.elasticsearchUrlInput.props, {
    isUrl: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",
      defaultMessage: "Service Token"
    })
  }, inputs.serviceTokenInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "serviceTokenSecretInput"
  }, inputs.serviceTokenInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.serviceTokenLabel', {
      defaultMessage: 'Service Token'
    })
  }, inputs.serviceTokenSecretInput.formRowProps, {
    cancelEdit: inputs.serviceTokenSecretInput.cancelEdit,
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "serviceTokenSecretInput",
    fullWidth: true
  }, inputs.serviceTokenSecretInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",
      defaultMessage: "Generate a service token by running this API request in the Remote Kibana Console and copy the response value"
    }),
    "data-test-subj": "serviceTokenCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, `POST kbn:/api/fleet/service_tokens
{
  "remote": true
}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.OutputFormRemoteEsSection = OutputFormRemoteEsSection;