"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadSourceTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;

// Allow child to be truncated
const FlexGroupWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 0px;
`;
const DownloadSourceTable = ({
  downloadSources,
  deleteDownloadSource
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: downloadSource => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: downloadSource.name,
        className: `eui-textTruncate`,
        "data-test-subj": "editDownloadSourceTable.name"
      }, downloadSource.name))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      truncateText: true,
      render: downloadSource => /*#__PURE__*/_react.default.createElement(FlexGroupWithMinWidth, {
        direction: "column",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: downloadSource.host
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: downloadSource.host,
        className: `eui-textTruncate`,
        "data-test-subj": "editDownloadSourceTable.host"
      }, downloadSource.host))),
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.hostColumnTitle', {
        defaultMessage: 'Host'
      })
    }, {
      render: downloadSource => downloadSource.is_default ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        "data-test-subj": "editDownloadSourceTable.defaultIcon"
      }) : null,
      width: '200px',
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle', {
        defaultMessage: 'Default'
      })
    }, {
      width: '68px',
      render: downloadSource => {
        const isDeleteVisible = !downloadSource.is_default;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "trash",
          onClick: () => deleteDownloadSource(downloadSource),
          title: _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.deleteButtonTitle', {
            defaultMessage: 'Delete'
          }),
          "data-test-subj": "editDownloadSourceTable.delete.btn"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_download_sources', {
            downloadSourceId: downloadSource.id
          }),
          title: _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.editButtonTitle', {
            defaultMessage: 'Edit'
          }),
          "data-test-subj": "editDownloadSourceTable.edit.btn"
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.downloadSourceSection.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [deleteDownloadSource, getHref]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: downloadSources,
    "data-test-subj": "AgentDownloadSourcesTable"
  });
};
exports.DownloadSourceTable = DownloadSourceTable;