"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _icons = require("../../../../../services/icons");
var _hooks = require("../../../hooks");
var _ = require("..");
var _services = require("../../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchInstalledIntegrations = async () => {
  var _response$data;
  const response = await (0, _hooks.sendGetPackages)({
    prerelease: true
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  const installedIntegrations = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items.filter(({
    status
  }) => status === 'installed');
  return installedIntegrations;
};
const IntegrationDebugger = () => {
  var _integrations$data$ma, _integrations$data, _integrations$data2, _selectedOptions$0$ic, _selectedOptions$;
  const {
    http,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [selectedIntegrationId, setSelectedIntegrationId] = (0, _react.useState)();
  const [isReinstallModalVisible, setIsReinstallModalVisible] = (0, _react.useState)(false);
  const [isUninstallModalVisible, setIsUninstallModalVisible] = (0, _react.useState)(false);
  const integrations = (0, _reactQuery.useQuery)(['debug-integrations'], fetchInstalledIntegrations);
  const uninstallMutation = (0, _reactQuery.useMutation)(async integration => {
    const response = await (0, _hooks.sendRemovePackage)(integration.name, integration.version, true);
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.uninstall.error', {
          defaultMessage: 'Error uninstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: response.error.message
      });
      setIsUninstallModalVisible(false);
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.uninstall.success', {
      defaultMessage: 'Successfully uninstalled {integrationTitle}',
      values: {
        integrationTitle: integration.title
      }
    }));
    setSelectedIntegrationId(undefined);
    setIsUninstallModalVisible(false);
    _.queryClient.invalidateQueries(['debug-integrations']);
    return response.data;
  });
  const reinstallMutation = (0, _reactQuery.useMutation)(async integration => {
    const uninstallResponse = await (0, _hooks.sendRemovePackage)(integration.name, integration.version, true);
    if (uninstallResponse.error) {
      notifications.toasts.addError(uninstallResponse.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.error', {
          defaultMessage: 'Error reinstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: uninstallResponse.error.message
      });
      setIsReinstallModalVisible(false);
      throw new Error(uninstallResponse.error.message);
    }
    const installResponse = await (0, _hooks.sendInstallPackage)(integration.name, integration.version);
    if (installResponse.error) {
      notifications.toasts.addError(new Error(installResponse.error.message), {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.error', {
          defaultMessage: 'Error reinstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: installResponse.error.message
      });
      setIsReinstallModalVisible(false);
      throw new Error(installResponse.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.success', {
      defaultMessage: 'Successfully reinstalled {integrationTitle}',
      values: {
        integrationTitle: integration.title
      }
    }));
    setSelectedIntegrationId(undefined);
    setIsReinstallModalVisible(false);
    _.queryClient.invalidateQueries(['debug-integrations']);
    return installResponse.data;
  });
  if (integrations.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Error",
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.debug.integrationDebugger.fetchError",
      defaultMessage: "Error fetching installed Integrations"
    }));
  }
  const comboBoxOptions = (_integrations$data$ma = (_integrations$data = integrations.data) === null || _integrations$data === void 0 ? void 0 : _integrations$data.map(integration => ({
    label: integration.name,
    value: integration.id,
    icon: (0, _icons.getEuiIconType)(integration, http.basePath)
  }))) !== null && _integrations$data$ma !== void 0 ? _integrations$data$ma : [];
  const selectedOptions = selectedIntegrationId ? [comboBoxOptions.find(option => option.value === selectedIntegrationId)] : [];
  const selectedIntegration = (_integrations$data2 = integrations.data) === null || _integrations$data2 === void 0 ? void 0 : _integrations$data2.find(integration => integration.id === selectedIntegrationId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.description",
    defaultMessage: "Use this tool to uninstall or reinstall installed integrations."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.reinstallationDescription",
    defaultMessage: "Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 600px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.selectLabel', {
      defaultMessage: 'Select an Integration'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.selectLabel', {
      defaultMessage: 'Select an Integration'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    isDisabled: integrations.status === 'loading',
    prepend: selectedOptions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_selectedOptions$0$ic = (_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.icon) !== null && _selectedOptions$0$ic !== void 0 ? _selectedOptions$0$ic : 'fleetApp'
    })) : undefined,
    renderOption: (option, searchValue, contentClassName) => /*#__PURE__*/_react.default.createElement("span", {
      className: contentClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: option.icon
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)),
    onChange: newSelectedOptions => {
      // Handle "clear" action
      if (!newSelectedOptions.length) {
        setSelectedIntegrationId(undefined);
      } else {
        setSelectedIntegrationId(newSelectedOptions[0].value);
      }
    }
  })), selectedIntegration && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => setIsReinstallModalVisible(true)
  }, "Reinstall")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: () => setIsUninstallModalVisible(true)
  }, "Uninstall")), isReinstallModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: `Reinstall ${selectedIntegration.title}`,
    onCancel: () => setIsReinstallModalVisible(false),
    onConfirm: () => reinstallMutation.mutate(selectedIntegration),
    isLoading: reinstallMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.cancelReinstall', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.confirmReinstall', {
      defaultMessage: 'Reinstall'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.reinstallModal",
    defaultMessage: "Are you sure you want to reinstall {integrationTitle}?",
    values: {
      integrationTitle: selectedIntegration.title
    }
  })), isUninstallModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: `Uninstall ${selectedIntegration.title}`,
    onCancel: () => setIsUninstallModalVisible(false),
    onConfirm: () => uninstallMutation.mutate(selectedIntegration),
    isLoading: uninstallMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.cancelUninstall', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.confirmUninstall', {
      defaultMessage: 'Uninstall'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.uninstallModal",
    defaultMessage: "Are you sure you want to uninstall {integrationTitle}?",
    values: {
      integrationTitle: selectedIntegration.title
    }
  })))), selectedIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getHref('integration_details_overview', {
      pkgkey: (0, _services.pkgKeyFromPackageInfo)({
        name: selectedIntegration.name,
        version: selectedIntegration.version
      })
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.viewIntegrationLink",
    defaultMessage: "View integration settings in Integrations UI"
  }))));
};
exports.IntegrationDebugger = IntegrationDebugger;