"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_STATUS = exports.AgentPolicyCreatedCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CREATE_STATUS;
exports.CREATE_STATUS = CREATE_STATUS;
(function (CREATE_STATUS) {
  CREATE_STATUS["INITIAL"] = "initial";
  CREATE_STATUS["CREATED"] = "created";
  CREATE_STATUS["FAILED"] = "failed";
})(CREATE_STATUS || (exports.CREATE_STATUS = CREATE_STATUS = {}));
const AgentPolicyCreatedCallOut = ({
  createState
}) => {
  var _createState$errorMes;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), createState.status === CREATE_STATUS.CREATED ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "agentPolicyCreateStatusCallOut",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyCreation.created",
      defaultMessage: "Agent policy created"
    }),
    color: "success",
    iconType: "check"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "agentPolicyCreateStatusCallOut",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyCreation.failed",
      defaultMessage: "Agent policy creation failed"
    }),
    color: "danger",
    iconType: "cross"
  }, (_createState$errorMes = createState.errorMessage) !== null && _createState$errorMes !== void 0 ? _createState$errorMes : null));
};
exports.AgentPolicyCreatedCallOut = AgentPolicyCreatedCallOut;